<?php
/**
 * Interface Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Contracts\With_Text_Generation
 */

namespace Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Contracts;

use Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\API\Types\Candidates;
use Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\API\Types\Content;
use Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\API\Types\Parts;
use Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Exception\Generative_AI_Exception;
use Generator;
use InvalidArgumentException;

/**
 * Interface for a model which allows generating text content.
 */
interface With_Text_Generation {

	/**
	 * Generates text content using the model.
	 *
	 * @param string|Parts|Content|Content[] $content         Prompt for the content to generate. Optionally, an array
	 *                                                        can be passed for additional context (e.g. chat history).
	 * @param array<string, mixed>           $request_options Optional. The request options. Default empty array.
	 * @return Candidates The response candidates with generated text content - usually just one.
	 *
	 * @throws InvalidArgumentException Thrown if the given content is invalid.
	 * @throws Generative_AI_Exception Thrown if the request fails or the response is invalid.
	 */
	public function generate_text( $content, array $request_options = array() ): Candidates;
}
