<?php
/**
 * Class Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Util\AI_Capabilities
 */

namespace Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Util;

use Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\API\Enums\AI_Capability;
use Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Contracts\With_Text_Generation;
use InvalidArgumentException;

/**
 * Class exposing the available AI capabilities and related static utility methods.
 */
final class AI_Capabilities {

	/**
	 * Gets the AI capabilities that the given model class supports.
	 *
	 * @param string $model_class The model class name.
	 * @return string[] The AI capabilities that the model class supports.
	 */
	public static function get_model_class_capabilities( string $model_class ): array {
		$interfaces = class_implements( $model_class );

		$capabilities = array();
		if ( isset( $interfaces[ With_Text_Generation::class ] ) ) {
			$capabilities[] = AI_Capability::TEXT_GENERATION;
		}
		return $capabilities;
	}

	/**
	 * Gets the model slugs that satisfy the given capabilities.
	 *
	 * @param array<string, string[]> $models       Map of the available model slugs and their capabilities.
	 * @param string[]                $capabilities The required capabilities that the models should satisfy.
	 * @return string[] Slugs of all models that satisfy the given capabilities.
	 */
	public static function get_model_slugs_for_capabilities( array $models, array $capabilities ): array {
		$model_slugs = array();

		foreach ( $models as $model_slug => $model_caps ) {
			if ( ! array_diff( $capabilities, $model_caps ) ) {
				$model_slugs[] = $model_slug;
			}
		}

		return $model_slugs;
	}
}
