<?php
/**
 * API functions.
 *
 * @return Services_API The API instance.
 */

use Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Services_API;
use Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Services_API_Instance;

/**
 * Returns the AI services API instance, which is used to interact with the AI services.
 *
 * Examples:
 *
 * ```
 * ai_translate()->get_available_service()
 *   ->get_model( array( 'feature' => 'my-test-feature' ) )
 *   ->generate_text( 'How can you help me?' )
 * ```
 *
 * ```
 * ai_translate()->get_available_service( 'google' )
 *   ->get_model(
 *     array(
 *       'feature' => 'my-test-feature',
 *       'model'   => 'gemini-1.5-pro',
 *     )
 *   )
 *   ->generate_text( 'How can you help me?' )
 * ```
 *
 * @since 0.1.0
 *
 * @return Services_API The API instance.
 */
function ai_translate() {
	return Services_API_Instance::get();
}
