<?php

/**
 * MainWP WP Rocket
 *
 * MainWP WP Rocket Extension handler.
 *
 * @link https://mainwp.com/extension/rocket/
 *
 * @package MainWP\Child
 *
 * Credits
 *
 * Plugin-Name: WP Rocket
 * Plugin URI: https://wp-rocket.me
 * Author:  WP Media
 * Author URI: https://wp-media.me
 * Licence: GPLv2 or later
 */
class MainWP_Rocket_Utility{ //phpcs:ignore -- NOSONAR - multi methods.
    public static function ctype_digit( $str ) {
        return ( is_string( $str ) || is_int( $str ) || is_float( $str ) ) && preg_match( '/^\d+\z/', $str );
    }

    public static function map_site( &$website, $keys ) {
        $outputSite = array();
        foreach ( $keys as $key ) {
            $outputSite[ $key ] = $website->$key;
        }
        return $outputSite;
    }

    public static function get_data_authed( $website, $paramValue, $paramName = 'where', $open_location = '' ) {
        $params = array();
        if ( $website && '' != $paramValue ) {
            $nonce = random_int( 0, 9999 );
            if ( ( $website->nossl == 0 ) && function_exists( 'openssl_verify' ) ) {
                $nossl = 0;
                openssl_sign( $paramValue . $nonce, $signature, base64_decode( $website->privkey ) );
            } else {
                $nossl     = 1;
                $signature = md5( $paramValue . $nonce . $website->nosslkey ); // NOSONAR - safe.
            }
            $signature = base64_encode( $signature );

            $params = array(
                'login_required'  => 1,
                'user'            => $website->adminname,
                'mainwpsignature' => rawurlencode( $signature ),
                'nonce'           => $nonce,
                'nossl'           => $nossl,
                'open_location'   => $open_location,
                $paramName        => rawurlencode( $paramValue ),
            );
        }

        $url  = ( isset( $website->siteurl ) && $website->siteurl != '' ? $website->siteurl : $website->url );
        $url .= ( substr( $url, -1 ) != '/' ? '/' : '' );
        $url .= '?';

        foreach ( $params as $key => $value ) {
            $url .= $key . '=' . $value . '&';
        }

        return rtrim( $url, '&' );
    }
}
