<?php

namespace MapSVG;

use Error;

/**
 * Clockwork Controller Class.
 * Provides logs data to the browser
 */
class ClockworkController extends Controller
{

	public static function index($request)
	{
		$res = Logger::getMetaData($request['params']);
		$statusCode = http_response_code();
		$resData = $res ? json_decode($res) : null;

		return new \WP_REST_Response($resData, $statusCode);
	}
	/**
	 * @param \WP_REST_Request $request
	 * @return \WP_REST_Response
	 */
	public static function auth($request)
	{
		$loggerAuth = new LoggerAuth();

		$token = $loggerAuth->attempt($request->get_params());
		if ($token) {
			return new \WP_REST_Response(["token" => $token]);
		} else {
			return new \WP_REST_Response(["message" => "", "requires" => $loggerAuth->requires()], 403);
		}
	}
}
