<?php

namespace MapSVG;

use Clockwork\Support\Vanilla\Clockwork as BaseClockwork;

class CustomClockwork extends BaseClockwork
{
  protected function response($data = null, $status = null, $json = true, $mimetype = null)
  {
    $data = $json ? json_encode($data, JSON_PARTIAL_OUTPUT_ON_ERROR) : $data;
    $mimetype = $json ? 'application/json' : $mimetype;

    if ($mimetype !== null) {
      $this->setHeader('Content-Type', $mimetype);
    }

    if ($this->psrResponse) {
      if ($status) $this->psrResponse = $this->psrResponse->withStatus($status);
      if ($data !== null) $this->psrResponse->getBody()->write($data);
      return $this->psrResponse;
    } else {
      if ($status) http_response_code($status);
      // Return data instead of echoing
      return $data;
    }
  }
}
