import path from "path"
import { getConfig, DEMO_WP_PATH, BUILDS_PATH } from "../constants/config.js"

export const handleTerminalOutput = (error, stdout, stderr) => {
  if (error) {
    console.error(`exec error: ${error}`)
  }
  console.log(stdout)
  if (stderr) {
    console.error(`stderr: ${stderr}`)
  }
}

export const getReleaseFileName = ({ version }) => {
  return `${version}.zip`
}

export const getBuildFolderPath = (slug) => {
  if (slug === "mapsvg-demo") {
    return DEMO_WP_PATH
  } else {
    return path.resolve(BUILDS_PATH, slug)
  }
}
export const getReleasePath = ({ slug, version }) => {
  const { RELEASES_PATH } = getConfig()
  return path.resolve(RELEASES_PATH, slug, getReleaseFileName({ version }))
}
export const getReleaseFolderPath = (slug) => {
  const { RELEASES_PATH } = getConfig()
  return path.resolve(RELEASES_PATH, slug)
}

export const getRemoteReleaseUrl = ({ slug, version }) => {
  const { MAPSVG_API_URL } = getConfig()
  return `${MAPSVG_API_URL}/releases/${slug}/${version}`
}
