import yargs from "yargs"
import { hideBin } from "yargs/helpers"
import { plans } from "../constants/plans.js"

export const getPlanFromCli = () => {
  const planNames = plans.map((plan) => plan.name)
  const argv = yargs(hideBin(process.argv)).option("plan", {
    choices: planNames,
    demandOption: true,
    description: "Specify the plan to deploy",
  }).argv

  const planName = argv.plan || null

  if (!planName) {
    throw new Error("Please specify a plan")
  }

  return plans.find((p) => p.slug === `mapsvg-${planName}`)
}
