<?php

namespace MapSVG;

use Clockwork\Authentication\AuthenticatorInterface;

class LoggerAuth implements AuthenticatorInterface
{
  public function __construct() {}

  public function attempt(array $credentials)
  {
    $tokenRepo = RepositoryFactory::get("token");
    $token = $tokenRepo->findOne(["hashedToken" => md5($credentials['password'])]);
    if ($token && $token->accessRights && ($token->accessRights["logs"] || $token->accessRights["wp"])) {
      return $token->hashedToken;
    }
    return null;
  }

  public function check($token)
  {
    $tokenRepo = RepositoryFactory::get("token");
    $token = $tokenRepo->findOne(["hashedToken" => $token]);
    return !empty($token);
  }

  public function requires()
  {
    return [self::REQUIRES_PASSWORD];
  }
}
