/**
 * MapSVG 6.2.13.1 - Interactive Map Plugin
 *
 * Author: Roman S. Stepanov
 * http://codecanyon.net/user/RomanCode/portfolio?ref=RomanCode
 *
 * MapSVG @CodeCanyon: http://codecanyon.net/item/jquery-interactive-svg-map-plugin/1694201?ref=RomanCode
 * Licenses: http://codecanyon.net/licenses/regular_extended?ref=RomanCode
 */
!function($){function isNumber(e){return!isNaN(parseFloat(e))&&isFinite(e)}function ucfirst(e){return e.charAt(0).toUpperCase()+e.slice(1)}function parseBoolean(e){switch(String(e).toLowerCase()){case"on":case"true":case"1":case"yes":case"y":return!0;case"off":case"false":case"0":case"no":case"n":return!1;default:return}}function safeURL(e){return(0==e.indexOf("http://")||0==e.indexOf("https://"))&&(e="//"+e.split("://").pop()),e}function extend(e,t){e.prototype=Object.create(t.prototype),e.prototype.constructor=e}function MapObject(){this.id=""}function Region(e,t,o,i){if(MapObject.call(this),this.node=e,this.nodeType=e[0].tagName,this.globalOptions=t,this.mapsvg=i,this.id=this.node.attr("id"),this.id||(this.setId(this.nodeType+"_"+o.id++),this.autoID=!0),this.id_no_spaces=this.id.replace(" ","_"),this.title=this.node.attr("title"),this.node[0].setAttribute("class","mapsvg-region"),this.svg_style={fill:this.getComputedStyle("fill")},this.svg_style.stroke=this.getComputedStyle("stroke"),_browser.ie){var s=this.getComputedStyle("stroke-width");s=s?s.replace("px",""):"1",s="1"==s?1.2:parseFloat(s),this.svg_style["stroke-width"]=s}else this.node.css({"vector-effect":"non-scaling-stroke"});var n=t.regions&&t.regions[this.id]?t.regions[this.id]:null;this.disabled=this.getDisabledState(),this.disabled&&this.attr("class",this.attr("class")+" mapsvg-disabled"),this.default_attr={},this.selected_attr={},this.hover_attr={},this.mapsvg_type="region";var r=!1;n&&n.selected&&(r=!0,delete n.selected),n&&this.update(n),this.setFill(),r&&this.setSelected(!0),this.saveState()}function Marker(e,t){if(!e.id||!e.src)return!1;MapObject.call(this);var o=document.createElementNS("http://www.w3.org/2000/svg","image");o.setAttributeNS(null,"height",e.height),o.setAttributeNS(null,"width",e.width),o.setAttributeNS("http://www.w3.org/1999/xlink","href",e.src),o.setAttributeNS(null,"x",e.x),o.setAttributeNS(null,"y",e.y),o.setAttributeNS(null,"visibility","visible"),o.setAttribute("class","mapsvg-marker"),this.node=$(o),this.src=e.src,this.setId(e.id),this.mapsvg_type="marker",this.x=parseFloat(e.x),this.y=parseFloat(e.y),this.width=parseFloat(e.width),this.height=parseFloat(e.height),this.tooltip=e.tooltip,this.popover=e.popover,this.href=e.href,this.target=e.target,this["default"]={x:this.x,y:this.y,width:this.width,height:this.height},this.geoCoords=e.geoCoords,this.data=e.data}var mapSVG={};MapObject.prototype.getComputedStyle=function(e,t){if(t=t||this.node[0],_p1=t.getAttribute(e))return _p1;if(_p2=t.getAttribute("style")){var o=_p2.split(";"),i=o.filter(function(t){var t=t.trim(),o=t.split(":");return o[0]==e?!0:void 0});if(i.length)return i[0].split(":").pop().trim()}var s=$(t).parent(),n=s.length?s[0].tagName:null;return n&&"svg"!=n?this.getComputedStyle(e,s[0]):void 0},MapObject.prototype.getStyle=function(e){if(_p1=this.attr(e))return _p1;if(_p2=this.attr("style")){var t=_p2.split(";"),o=t.filter(function(t){var t=t.trim();return 0===t.indexOf(e)?t:void 0});return o.length?o[0].split(":").pop().trim():void 0}return""},MapObject.prototype.getCenter=function(){var e=this.node[0].getBoundingClientRect().left,t=this.node[0].getBoundingClientRect().top,o=this.node[0].getBoundingClientRect().width,i=this.node[0].getBoundingClientRect().height;return[e+o/2,t+i/2]},MapObject.prototype.setTooltip=function(e){this.tooltip=e?e:void 0},MapObject.prototype.setPopover=function(e){this.popover=e?e:void 0},MapObject.prototype.setHref=function(e){if(this.href&&this.node.parent("a").length&&this.node.unwrap(),this.href=e?e:void 0,this.href){var t="http://www.w3.org/1999/xlink",o="http://www.w3.org/2000/svg",i=document.createElementNS(o,"a");i.setAttributeNS(t,"href",this.href),this.target&&i.setAttribute("target",this.target),this.node.wrap($(i))}},MapObject.prototype.setTarget=function(e){if(this.target=e?e:void 0,this.href){var t=this.node.parent("a")[0];this.target?t.setAttribute("target",e):t.removeAttribute("target")}},MapObject.prototype.setData=function(data){if(data){if("string"==typeof data)if("["==data.substr(0,1)||"{"==data.substr(0,1))try{var tmp;eval("tmp = "+data),this.data=tmp}catch(err){var error="MapSVG: Error in Data object for "+this.mapsvg_type+" '"+this.id+"'. Data object was set to empty object {}.";return this.data={},{_error:error}}else this.data=data;else this.data=data;return this.data}this.data=void 0},MapObject.prototype.attr=function(e,t){var o=this.node[0];if("object"==typeof e)$.each(e,function(e,t){("string"==typeof t||"number"==typeof t)&&o.setAttribute(e,t)});else if("string"!=typeof e||"string"!=typeof t&&"number"!=typeof t){if(void 0==t)return o.getAttribute(e)}else o.setAttribute(e,t)},MapObject.prototype.setId=function(e){return e?(this.id=e,void this.node[0].setAttribute("id",e)):!1},extend(Region,MapObject),Region.prototype.saveState=function(){this.initialState=JSON.stringify(this.getOptions())},Region.prototype.changed=function(){return JSON.stringify(this.getOptions())!=this.initialState},Region.prototype.getOptions=function(e){var t=(this.globalOptions.regions[this.id],{id:this.id,id_no_spaces:this.id_no_spaces,title:this.title,disabled:this.disabled===this.getDisabledState(!0)?void 0:this.disabled,fill:this.globalOptions.regions[this.id]&&this.globalOptions.regions[this.id].fill,tooltip:this.tooltip,popover:this.popover,href:this.href,target:this.target,data:this.data,gaugeValue:this.gaugeValue});return e&&(t.disabled=this.disabled),$.each(t,function(e,o){void 0==o&&delete t[e]}),t},Region.prototype.update=function(e){for(var t in e){var o="set"+ucfirst(t);o in this&&this[o](e[t])}},Region.prototype.setFill=function(e){if(e?(regions={},regions[this.id]={fill:e},$.extend(!0,this.globalOptions,{regions:regions})):""==e&&this.globalOptions.regions&&this.globalOptions.regions[this.id]&&this.globalOptions.regions[this.id].fill&&delete this.globalOptions.regions[this.id].fill,this.globalOptions.gauge.on&&this.gaugeValue){var t=this.globalOptions.gauge,o=(this.gaugeValue-t.min)/t.maxAdjusted,i={r:Math.round(t.colors.diffRGB.r*o+t.colors.lowRGB.r),g:Math.round(t.colors.diffRGB.g*o+t.colors.lowRGB.g),b:Math.round(t.colors.diffRGB.b*o+t.colors.lowRGB.b),a:Math.round(t.colors.diffRGB.a*o+t.colors.lowRGB.a)};this.default_attr.fill="rgba("+i.r+","+i.g+","+i.b+","+i.a+")"}else this.globalOptions.regions[this.id]&&this.globalOptions.regions[this.id].fill?this.default_attr.fill=this.globalOptions.regions[this.id].fill:this.disabled&&this.globalOptions.colors.disabled?this.default_attr.fill=this.globalOptions.colors.disabled:this.globalOptions.colors.base?this.default_attr.fill=this.globalOptions.colors.base:"none"!=this.svg_style.fill?this.default_attr.fill=this.svg_style.fill?this.svg_style.fill:this.globalOptions.colors.baseDefault:this.default_attr.fill="none";isNumber(this.globalOptions.colors.selected)?this.selected_attr.fill=tinycolor(this.default_attr.fill).lighten(parseFloat(this.globalOptions.colors.selected)).toRgbString():this.selected_attr.fill=this.globalOptions.colors.selected,isNumber(this.globalOptions.colors.hover)?this.hover_attr.fill=tinycolor(this.default_attr.fill).lighten(parseFloat(this.globalOptions.colors.hover)).toRgbString():this.hover_attr.fill=this.globalOptions.colors.hover,this.node.css("fill",this.default_attr.fill),this.fill=this.default_attr.fill,"none"!=this.svg_style.stroke&&void 0!=this.globalOptions.colors.stroke?this.node.css("stroke",this.globalOptions.colors.stroke):this.node.css("stroke",this.svg_style.stroke),this.selected&&this.select()},Region.prototype.setDisabled=function(e){e=void 0!==e?parseBoolean(e):this.getDisabledState(),this.disabled=e,e?this.attr("class",this.attr("class")+" mapsvg-disabled"):this.attr("class",this.attr("class").replace(" mapsvg-disabled","")),this.selected=!1,this.setFill()},Region.prototype.setSelected=function(e){this.mapsvg.selectRegion(this)},Region.prototype.setGaugeValue=function(e){this.gaugeValue=$.isNumeric(e)?parseFloat(e):void 0},Region.prototype.getDisabledState=function(e){var t=this.globalOptions.regions[this.id];return!e&&t&&void 0!==t.disabled?t.disabled:this.globalOptions.disableAll||"none"==this.svg_style.fill||"labels"==this.id||"Labels"==this.id?!0:!1},Region.prototype.highlight=function(){this.node.css({fill:this.hover_attr.fill})},Region.prototype.unhighlight=function(){this.node.css({fill:this.default_attr.fill})},Region.prototype.select=function(){this.node.css({fill:this.selected_attr.fill}),this.selected=!0},Region.prototype.deselect=function(){this.node.css({fill:this.default_attr.fill}),this.selected=!1},extend(Marker,MapObject),Marker.prototype.getOptions=function(){var e={id:this.id,tooltip:this.tooltip,popover:this.popover,href:this.href,target:this.target,data:this.data,src:this.src,width:this["default"].width,height:this["default"].height,x:this.x,y:this.y,geoCoords:this.geoCoords};return $.each(e,function(t,o){void 0==o&&delete e[t]}),e},Marker.prototype.setXY=function(e,t){this.x=e,this.y=t,this.node[0].setAttribute("x",e),this.node[0].setAttribute("y",t),this.adjustPosition(this.mapScale)},Marker.prototype.update=function(e,t){for(var o in e){var i="set"+ucfirst(o);i in this&&this[i](e[o],t)}},Marker.prototype.setSrc=function(e,t){if(!e)return!1;e=safeURL(e),t=t||this.mapScale;var o=new Image,i=this;o.onload=function(){i["default"].width=this.width,i["default"].height=this.height,i.x=i.x-(this.width-i.width)/2,i.y=i.y-(this.height-i.height),i.attr({x:i.x,y:i.y,width:this.width,height:this.height}),i.width=this.width,i.height=this.height,i.node[0].setAttributeNS("http://www.w3.org/1999/xlink","href",e),i.adjustPosition(t),i.src=e},o.src=e},Marker.prototype.adjustPosition=function(e){var t=this["default"].width,o=this["default"].height,i=t/2-t/(2*e),s=o-o/e;this.attr("width",t/e),this.attr("height",o/e),this.attr("transform","translate("+i+","+s+")"),this.mapScale=e},Marker.getDefaultCoords=function(e,t,o,i,s){return e=parseFloat(e),t=parseFloat(t),o=parseFloat(o),i=parseFloat(i),e=e+o/(2*s)-o/2,t=t+i/s-i,[e,t]},Marker.prototype.drag=function(e,t,o,i){_this=this,this.ox=this.x,this.oy=this.y,$("body").on("mousemove.drag.mapsvg",function(o){o.preventDefault();var i=mouseCoords(o),s=i.x-e.x,n=i.y-e.y;_this.x=_this.ox+s/t,_this.y=_this.oy+n/t,_this.attr({x:_this.x,y:_this.y})}),$("body").on("mouseup.drag.mapsvg",function(s){s.preventDefault(),_this.undrag();var n=mouseCoords(s),r=n.x-e.x,a=n.y-e.y;_this.x=_this.ox+r/t,_this.y=_this.oy+a/t,_this.attr({x:_this.x,y:_this.y}),o.call(_this),_this.ox==_this.x&&_this.oy==_this.y&&i.call(_this)})},Marker.prototype.undrag=function(){$("body").off(".drag.mapsvg")},Marker.prototype["delete"]=function(){this.href&&this.node.parent("a").empty().remove(),this.node.empty().remove()};var instances={},globalID=0,userAgent=navigator.userAgent.toLowerCase(),scripts=document.getElementsByTagName("script"),myScript=scripts[scripts.length-1].src.split("/");myScript.pop();var pluginJSURL=myScript.join("/")+"/";myScript.pop();var pluginRootURL=myScript.join("/")+"/",touchDevice=userAgent.indexOf("ipad")>-1||userAgent.indexOf("iphone")>-1||userAgent.indexOf("ipod")>-1||userAgent.indexOf("android")>-1,_browser={};_browser.ie=userAgent.indexOf("msie")>-1||userAgent.indexOf("trident")>-1||userAgent.indexOf("edge")>-1?{}:!1,_browser.firefox=userAgent.indexOf("firefox")>-1,String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^\s+|\s+$/g,"")});var mouseCoords=function(e){return e.clientX?{x:e.clientX+$(document).scrollLeft(),y:e.clientY+$(document).scrollTop()}:e.pageX?{x:e.pageX,y:e.pageY}:touchDevice?(e=e.originalEvent,e.touches&&e.touches[0]?{x:e.touches[0].pageX,y:e.touches[0].pageY}:{x:e.changedTouches[0].pageX,y:e.changedTouches[0].pageY}):void 0},defaults={markerLastID:0,regionLastID:0,disableAll:!1,width:null,height:null,lockAspectRatio:!0,loadingText:"Loading map...",colors:{baseDefault:"#000000",background:"#eeeeee",selected:40,hover:20},regions:{},markers:[],viewBox:[],cursor:"default",onClick:null,mouseOver:null,mouseOut:null,beforeLoad:null,afterLoad:null,zoom:{on:!1,limit:[0,10],delta:1.2,buttons:{on:!0,location:"right"},mousewheel:!0},scroll:{on:!1,limit:!1,background:!1},responsive:!0,tooltips:{mode:"off",on:!1,priority:"local",position:"bottom-right"},popovers:{mode:"off",on:!1,priority:"local",position:"top"},multiSelect:!1,gauge:{on:!1,labels:{low:"low",high:"high"},colors:{lowRGB:null,highRGB:null,low:"#550000",high:"#ee0000"},min:0,max:0},menu:{on:!1,containerId:"",template:function(e){return'<li><a href="#'+e.id+'">'+(e.title||e.id)+"</a></li>"}}},markerOptions={src:pluginRootURL+"markers/pin1_red.png"};mapSVG=function(e,t){var o;this.methods={mouseCoords:mouseCoords,functionFromString:function(e){var t,o=!1,i=e;if(-1==i.indexOf("{")||-1==i.indexOf("function")||-1==i.indexOf("("))return{error:"MapSVG user function error: no function body."};var s=i.substring(i.indexOf("{")+1,i.lastIndexOf("}")),n=i.substring(i.indexOf("(")+1,i.indexOf(")"));try{t=new Function(n,s),success=!0}catch(r){o=r}return o?{error:{line:o.line,text:"MapSVG user function error: (line "+o.line+"): "+o.message}}:t},getOptions:function(e,t){var i=$.extend(!0,{},o.options);return i.viewBox=o._viewBox,delete i.markers,e?(i.regions=[],o.regions.forEach(function(e){i.regions.push(e.getOptions())}),i.markers=o.options.markers):(o.regions.forEach(function(e){e.changed()&&(i.regions[e.id]=e.getOptions())}),o.markers.length>0&&(i.markers=[]),o.markers.forEach(function(e){i.markers.push(e.getOptions())})),t&&$.each(i,function(e,t){JSON.stringify(t)==JSON.stringify(defaults[e])&&delete i[e]}),i},update:function(e){for(var t in e)if("regions"==t)$.each(e.regions,function(e,t){var s=i.getRegion(e);s&&s.update(t),void 0!=t.gaugeValue&&(i.updateGaugeMinMax(),i.regionsRedrawColors()),void 0!=t.disabled&&(i.deselectRegion(s),o.options.regions[e]=o.options.regions[e]||{},o.options.regions[e].disabled=s.disabled)});else if("markers"==t)$.each(e.markers,function(e,t){var o=i.getMarker(e);if(t.geoCoords){if("string"==typeof t.geoCoords&&(t.geoCoords=t.geoCoords.trim().split(","),t.geoCoords=[parseFloat(t.geoCoords[0]),parseFloat(t.geoCoords[1])]),"object"==typeof t.geoCoords&&2==t.geoCoords.length&&$.isNumeric(t.geoCoords[0])&&$.isNumeric(t.geoCoords[1])){var s=i.convertGeoToPixel(t.geoCoords);s[0]=s[0]-o.width/2+.3,s[1]=s[1]-o.height+1.5,o.setXY(s[0],s[1])}}else o&&o.update(t)});else{var s="set"+ucfirst(t);i.hasOwnProperty(s)?this[s](e[t]):console.log("MapSVG Error: no setter "+s+"()")}},setTitle:function(e){e&&(o.options.title=e)},setDisableLinks:function(e){e=parseBoolean(e),e?o.$map.on("click.a.mapsvg","a",function(e){e.preventDefault()}):o.$map.off("click.a.mapsvg"),o.disableLinks=e},setLoadingText:function(e){o.options.loadingText=e},setLockAspectRatio:function(e){o.options.lockAspectRatio=parseBoolean(e)},setOnClick:function(e){o.options.onClick=e||void 0},setMouseOver:function(e){o.options.mouseOver=e||void 0},setMouseOut:function(e){o.options.mouseOut=e||void 0},setBeforeLoad:function(e){o.options.beforeLoad=e||void 0},setAfterLoad:function(e){o.options.afterLoad=e||void 0},setMarkerEditHandler:function(e){o.markerEditHandler=e},setRegionEditHandler:function(e){o.regionEditHandler=e},setDisableAll:function(e){e=parseBoolean(e),$.extend(!0,o.options,{disableAll:e}),o.regions.forEach(function(e){e.setDisabled()})},setColors:function(e){$.extend(!0,o.options,{colors:e}),$.each(o.options.colors,function(e,t){(null===t||""==t)&&delete t[e]}),e.background&&o.$map.css({background:o.options.colors.background}),e.hover&&(o.options.colors.hover=e.hover==""+parseInt(e.hover)?parseInt(e.hover):e.hover),e.selected&&(o.options.colors.selected=e.selected==""+parseInt(e.selected)?parseInt(e.selected):e.selected),i.regionsRedrawColors()},setTooltips:function(e){"string"==typeof e.mode&&0==e.mode.indexOf("function")&&(e.mode=i.functionFromString(e.mode)),o.options.tooltips.on="off"!=o.options.tooltips.mode,$.extend(!0,o.options,{tooltips:e}),o.mapTip||(o.mapTip=$("<div />").addClass("mapsvg-tooltip"),$("body").append(o.mapTip)),$("body").off("mousemove.tooltip.mapsvg");var t=o.mapTip[0];switch(o.options.tooltips.position){case"bottom-right":$("body").on("mousemove.tooltip.mapsvg",function(e){window.m=mouseCoords(e),t.style.left=e.clientX+$(window).scrollLeft()+"px",t.style.top=e.clientY+$(window).scrollTop()+25+"px"});break;case"bottom-left":$("body").on("mousemove.tooltip.mapsvg",function(e){window.m=mouseCoords(e),t.style.left=e.clientX+$(window).scrollLeft()-t.offsetWidth+10+"px",t.style.top=e.clientY+$(window).scrollTop()+25+"px"});break;case"bottom":$("body").on("mousemove.tooltip.mapsvg",function(e){window.m=mouseCoords(e),t.style.left=e.clientX+$(window).scrollLeft()-t.offsetWidth/2+"px",t.style.top=e.clientY+$(window).scrollTop()+25+"px"});break;case"top":$("body").on("mousemove.tooltip.mapsvg",function(e){window.m=mouseCoords(e),t.style.left=e.clientX+$(window).scrollLeft()-t.offsetWidth/2+"px",t.style.top=e.clientY+$(window).scrollTop()-t.offsetHeight-10+"px"});break;case"top-right":$("body").on("mousemove.tooltip.mapsvg",function(e){window.m=mouseCoords(e),t.style.left=e.clientX+$(window).scrollLeft()+"px",t.style.top=e.clientY+$(window).scrollTop()-t.offsetHeight-10+"px"});break;case"top-left":$("body").on("mousemove.tooltip.mapsvg",function(e){window.m=mouseCoords(e),t.style.left=e.clientX+$(window).scrollLeft()-t.offsetWidth+10+"px",t.style.top=e.clientY+$(window).scrollTop()-t.offsetHeight-10+"px"});break;case"left":$("body").on("mousemove.tooltip.mapsvg",function(e){window.m=mouseCoords(e),t.style.left=e.clientX+$(window).scrollLeft()-t.offsetWidth-10+"px",t.style.top=e.clientY+$(window).scrollTop()-t.offsetHeight/2+"px"});break;case"right":$("body").on("mousemove.tooltip.mapsvg",function(e){window.m=mouseCoords(e),t.style.left=e.clientX+$(window).scrollLeft()+15+"px",t.style.top=e.clientY+$(window).scrollTop()-t.offsetHeight/2+"px"})}},setPopovers:function(e){"string"==typeof e.mode&&0==e.mode.indexOf("function")&&(e.mode=i.functionFromString(e.mode)),$.extend(!0,o.options,{popovers:e}),o.options.popovers.on="off"!=o.options.popovers.mode,o.mapPopover||(o.mapPopover=$("<div />").addClass("mapsvg-popover"),o.mapPopover.closeButton=$('<div class="mapsvg-popover-close">&#10005;</div>'),o.mapPopover.contentDiv=$('<div class="mapsvg-popover-content"></div>'),o.mapPopover.append(o.mapPopover.contentDiv),o.mapPopover.append(o.mapPopover.closeButton),o.mapPopover.css({width:o.options.popovers.width+("auto"==o.options.popovers.width?"":"px"),height:o.options.popovers.height+("auto"==o.options.popovers.height?"":"px")}),o.mapPopover.closeButton.on("click",i.hidePopover),$("body").append(o.mapPopover)),$("body").off(".popover.mapsvg",i.popoverOffHandler),touchDevice||$("body").on("mousedown.popover.mapsvg",i.popoverOffHandler)},setInitialViewBox:function(e){"string"==typeof e&&(e=e.trim().split(" ")),o._viewBox=[parseFloat(e[0]),parseFloat(e[1]),parseFloat(e[2]),parseFloat(e[3])],o.zoomLevel=0},setViewBox:function(e,t){"string"==typeof e&&(e=e.trim().split(" "));var s=e&&4==e.length?e:o.svgDefault.viewBox,n=parseInt(s[2])!=o.viewBox[2]||parseInt(s[3])!=o.viewBox[3];return o.viewBox=[parseFloat(s[0]),parseFloat(s[1]),parseFloat(s[2]),parseFloat(s[3])],e||(o._viewBox=o.viewBox,o._scale=1),o.$svg[0].setAttribute("viewBox",o.viewBox.join(" ")),i.setResponsive(o.options.responsive,!0),n&&!t&&(o.scale=i.getScale(),i.markersAdjustPosition(),_browser.ie&&i.mapAdjustStrokes()),!0},redraw:function(){o.$map.css({width:o.$map.width(),height:o.$map.width()/o.whRatio}),_browser.ie?o.$map.css({width:"auto"}):o.$map.css({width:"auto",height:"auto"}),i.updateSize()},setSize:function(e,t,s){return o.options.width=parseFloat(e),o.options.height=parseFloat(t),o.options.responsive=null!=s?parseBoolean(s):o.options.responsive,o.options.width||o.options.height?!o.options.width&&o.options.height?o.options.width=parseInt(o.options.height*o.svgDefault.width/o.svgDefault.height):o.options.width&&!o.options.height&&(o.options.height=parseInt(o.options.width*o.svgDefault.height/o.svgDefault.width)):(o.options.width=o.svgDefault.width,o.options.height=o.svgDefault.height),o.whRatio=o.options.width/o.options.height,o.scale=i.getScale(),i.setResponsive(s),o.markers&&i.markersAdjustPosition(),[o.options.width,o.options.height]},setResponsive:function(e,t){e=void 0!=e?parseBoolean(e):o.options.responsive,$(window).off("resize.mapsvg"),e?($(window).on("resize.mapsvg",i.updateSize),o.$map.hasClass("mapsvg-responsive")||(o.$map.addClass("mapsvg-responsive"),o.$map.css({width:"auto",height:"auto"})),o.$map.height(o.$map.width()/o.whRatio),$(window).on("resize.mapsvg",function(){o.$map.height(o.$map.width()/o.whRatio),i.updateSize()})):(o.$map.removeClass("mapsvg-responsive"),o.$map.css({width:o.options.width+"px",height:o.options.height+"px"})),$.extend(!0,o.options,{responsive:e}),i.updateSize()},setScroll:function(e){null!=e.on&&(e.on=parseBoolean(e.on)),null!=e.limit&&(e.limit=parseBoolean(e.limit)),$.extend(!0,o.options,{scroll:e}),i.setEventHandlers()},setZoom:function(e){e=e||{},void 0!=e.on&&(e.on=parseBoolean(e.on)),void 0!=e.mousewheel&&(e.mousewheel=parseBoolean(e.mousewheel)),e.delta&&(e.delta=parseFloat(e.delta)),e.limit&&("string"==typeof e.limit&&(e.limit=e.limit.split(";")),e.limit=[parseInt(e.limit[0]),parseInt(e.limit[1])]),$.extend(!0,o.options,{zoom:e}),o.$map.off("mousewheel.mapsvg"),o.options.zoom.on&&o.options.zoom.mousewheel&&o.$map.on("mousewheel.mapsvg",function(e,t,o,s){var n=t>0?1:-1;return i.zoom(n),!1}),i.setZoomButtons()},setZoomButtons:function(){var e=o.options.zoom.buttons.location||"hide";if(!o.zoomButtons){var t=$("<div />").addClass("mapsvg-buttons");t.zoomIn=$("<div />").addClass("mapsvg-btn-zoom in");var s=touchDevice?"touchstart":"click";t.zoomIn.on(s,function(e){e.stopPropagation(),i.zoomIn()}),t.zoomOut=$("<div />").addClass("mapsvg-btn-zoom out"),t.zoomOut.on(s,function(e){e.stopPropagation(),i.zoomOut()}),t.append(t.zoomIn).append(t.zoomOut),o.zoomButtons=t,o.$map.append(o.zoomButtons)}o.zoomButtons.removeClass("left"),o.zoomButtons.removeClass("right"),"right"==e&&o.zoomButtons.addClass("right")||"left"==e&&o.zoomButtons.addClass("left"),o.options.zoom.on&&"hide"!=e?o.zoomButtons.show():o.zoomButtons.hide()},setCursor:function(e){e="pointer"==e?"pointer":"default",o.options.cursor=e,"pointer"==e?o.$map.addClass("mapsvg-cursor-pointer"):o.$map.removeClass("mapsvg-cursor-pointer")},setPreloaderText:function(e){o.options.loadingText=e},setMultiSelect:function(e){o.options.multiSelect=parseBoolean(e),i.deselectAllRegions()},setGauge:function(e){e=e||o.options.gauge,void 0!=e.on&&(e.on=parseBoolean(e.on)),$.extend(!0,o.options,{gauge:e});var t=!1;if(!o.$gauge){o.$gauge={},o.$gauge.gradient=$("<td>&nbsp;</td>").addClass("mapsvg-gauge-gradient"),i.setGaugeGradientCSS(),o.$gauge.container=$("<div />").addClass("mapsvg-gauge").hide(),o.$gauge.table=$("<table />");var s=$("<tr />");o.$gauge.labelLow=$("<td>"+o.options.gauge.labels.low+"</td>"),o.$gauge.labelHigh=$("<td>"+o.options.gauge.labels.high+"</td>"),s.append(o.$gauge.labelLow),s.append(o.$gauge.gradient),s.append(o.$gauge.labelHigh),o.$gauge.table.append(s),o.$gauge.container.append(o.$gauge.table),o.$map.append(o.$gauge.container)}!o.options.gauge.on&&o.$gauge.container.is(":visible")?(o.$gauge.container.hide(),t=!0):o.options.gauge.on&&!o.$gauge.container.is(":visible")&&(o.$gauge.container.show(),t=!0),e.colors&&(o.options.gauge.colors.lowRGB=tinycolor(o.options.gauge.colors.low).toRgb(),o.options.gauge.colors.highRGB=tinycolor(o.options.gauge.colors.high).toRgb(),o.options.gauge.colors.diffRGB={r:o.options.gauge.colors.highRGB.r-o.options.gauge.colors.lowRGB.r,g:o.options.gauge.colors.highRGB.g-o.options.gauge.colors.lowRGB.g,b:o.options.gauge.colors.highRGB.b-o.options.gauge.colors.lowRGB.b,a:o.options.gauge.colors.highRGB.a-o.options.gauge.colors.lowRGB.a},t=!0,o.$gauge&&i.setGaugeGradientCSS()),e.labels&&(o.$gauge.labelLow.html(o.options.gauge.labels.low),o.$gauge.labelHigh.html(o.options.gauge.labels.high)),t&&i.redrawGauge()},redrawGauge:function(){i.updateGaugeMinMax(),i.regionsRedrawColors()},updateGaugeMinMax:function(){o.options.gauge.min=0,o.options.gauge.max=!1;var e=[];o.regions.forEach(function(t){null!=t.gaugeValue&&void 0!=t.gaugeValue&&e.push(t.gaugeValue)}),e.length>0&&(o.options.gauge.min=1==e.length?0:Math.min.apply(null,e),o.options.gauge.max=Math.max.apply(null,e),o.options.gauge.maxAdjusted=o.options.gauge.max-o.options.gauge.min)},setGaugeGradientCSS:function(){o.$gauge.gradient.css({background:o.options.gauge.colors.low,background:"-moz-linear-gradient(left, "+o.options.gauge.colors.low+" 1%,"+o.options.gauge.colors.high+" 100%)",background:"-webkit-gradient(linear, left top, right top, color-stop(1%,"+o.options.gauge.colors.low+"), color-stop(100%,"+o.options.gauge.colors.high+"))",background:"-webkit-linear-gradient(left, "+o.options.gauge.colors.low+" 1%,"+o.options.gauge.colors.high+" 100%)",background:"-o-linear-gradient(left, "+o.options.gauge.colors.low+" 1%,"+o.options.gauge.colors.high+" 100% 100%)",background:"-ms-linear-gradient(left,  "+o.options.gauge.colors.low+" 1%,"+o.options.gauge.colors.high+" 100% 100%)",background:"linear-gradient(to right,"+o.options.gauge.colors.low+" 1%,"+o.options.gauge.colors.high+" 100%)",filter:'progid:DXImageTransform.Microsoft.gradient( startColorstr="'+o.options.gauge.colors.low+'", endColorstr="'+o.options.gauge.colors.high+'",GradientType=1 )'})},setMenu:function(e){if(e=e||o.options.menu,void 0!=e.on&&(e.on=parseBoolean(e.on)),$.extend(!0,o.options,{menu:e}),o.$menu&&o.$menu.off("click.menu.mapsvg"),o.options.menu.on){var t=$("#"+o.options.menu.containerId);t.length&&(o.$menu||(t.is("ul")?o.$menu=t:o.$menu=$("<ul />").appendTo(t),o.$menu.hasClass("mapsvg-menu")||o.$menu.addClass("mapsvg-menu")),0===o.$menu.children().length&&o.regions.forEach(function(e,t){e.disabled||o.$menu.append(o.options.menu.template(e))}),o.$menu.on("click.menu.mapsvg","a",function(e){e.preventDefault();var t=$(this).attr("href").replace("#",""),o=i.getRegion(t),s=o.getCenter();e.clientX=s[0],e.clientY=s[1],i.regionClickHandler(e,o)}).on("mouseover.menu.mapsvg","a",function(e){var t=$(this).attr("href").replace("#",""),o=i.getRegion(t);o.selected||o.highlight()}).on("mouseout.menu.mapsvg","a",function(e){var t=$(this).attr("href").replace("#",""),o=i.getRegion(t);o.selected||o.unhighlight()}))}},getRegion:function(e){return o.regions[o.regionsDict[e]]},getMarker:function(e){return o.markers[o.markersDict[e]]},checkId:function(e){return i.getRegion(e)?{error:"This ID is already being used by a Region"}:i.getMarker(e)?{error:"This ID is already being used by another Marker"}:!0},regionsRedrawColors:function(){o.regions.forEach(function(e){e.setFill()})},destroy:function(){return delete instances[o.$map.attr("id")],o.$map.empty(),i},getData:function(){return o},getScale:function(){var e,t=(o.svgDefault.width/o.svgDefault.height,o.options.width/o.options.height,[o.$map.width(),o.$map.height()]);return e=t[0]/o.viewBox[2],e||1},updateSize:function(){o.scale=i.getScale(),i.markersAdjustPosition(),_browser.ie&&i.mapAdjustStrokes()},getViewBox:function(){return o.viewBox},viewBoxSetBySize:function(e,t){return o._viewBox=i.viewBoxGetBySize(e,t),o.options.width=parseFloat(e),o.options.height=parseFloat(t),i.setViewBox(o._viewBox,!0),o.whRatio=o.viewBox[2]/o.viewBox[3],o.options.responsive||i.setResponsive(),o.viewBox},viewBoxGetBySize:function(e,t){var i=e/t,s=o.svgDefault.viewBox[2]/o.svgDefault.viewBox[3],n=$.extend([],o.svgDefault.viewBox);return i!=s&&(i>s?(n[2]=o.svgDefault.viewBox[3]*i,n[0]=o.svgDefault.viewBox[0]-(n[2]-o.svgDefault.viewBox[2])/2):(n[3]=o.svgDefault.viewBox[2]/i,n[1]=o.svgDefault.viewBox[1]-(n[3]-o.svgDefault.viewBox[3])/2)),n},viewBoxReset:function(e){if(e){var t=o._viewBox||o.svgDefault.viewBox;o.zoomLevel=0,o._scale=1,i.setViewBox(t)}else i.setViewBox()},getGeoViewBox:function(){var e=o.viewBox,t=i.convertPixelToGeo(e[0],e[1])[1],s=i.convertPixelToGeo(e[0]+e[2],e[1])[1],n=i.convertPixelToGeo(e[0],e[1])[0],r=i.convertPixelToGeo(e[0],e[1]+e[3])[0];return[t,n,s,r]},mapAdjustStrokes:function(){o.regions.forEach(function(e){e.svg_style["stroke-width"]&&e.node.css("stroke-width",e.svg_style["stroke-width"]/o.scale)})},zoomIn:function(){i.zoom(1)},zoomOut:function(){i.zoom(-1)},touchZoomStart:function(e){touchZoomStart=o._scale,o.scale=o.scale*zoom_k,zoom=o._scale,o._scale=o._scale*zoom_k;var t=o.viewBox[2],s=o.viewBox[3],n=[];n[2]=o._viewBox[2]/o._scale,n[3]=o._viewBox[3]/o._scale,n[0]=o.viewBox[0]+(t-n[2])/2,n[1]=viewBox[1]+(s-n[3])/2,i.setViewBox(n)},touchZoomMove:function(){},touchZoomEnd:function(){},zoom:function(e,t){var s=o.viewBox[2],n=o.viewBox[3],r=[];if(t)o._scale=t,r[2]=o.touchZoomStartViewBox[2]/o._scale,r[3]=o.touchZoomStartViewBox[3]/o._scale;else{var a=e>0?1:-1;if(o._zoomLevel=o.zoomLevel,o._zoomLevel+=a,o._zoomLevel>o.options.zoom.limit[1]||o._zoomLevel<o.options.zoom.limit[0])return!1;o.zoomLevel=o._zoomLevel;var l=a*o.options.zoom.delta;1>l&&(l=-1/l),o._scale=o._scale*l,r[2]=o._viewBox[2]/o._scale,r[3]=o._viewBox[3]/o._scale}r[0]=o.viewBox[0]+(s-r[2])/2,r[1]=o.viewBox[1]+(n-r[3])/2,o.options.scroll.limit&&(r[0]<o.svgDefault.viewBox[0]?r[0]=o.svgDefault.viewBox[0]:r[0]+r[2]>o.svgDefault.viewBox[0]+o.svgDefault.viewBox[2]&&(r[0]=o.svgDefault.viewBox[0]+o.svgDefault.viewBox[2]-r[2]),r[1]<o.svgDefault.viewBox[1]?r[1]=o.svgDefault.viewBox[1]:r[1]+r[3]>o.svgDefault.viewBox[1]+o.svgDefault.viewBox[3]&&(r[1]=o.svgDefault.viewBox[1]+o.svgDefault.viewBox[3]-r[3])),i.setViewBox(r)},markerDelete:function(e){var t=e.id;o.markers.splice(o.markersDict[t],1);e["delete"](),e=null,i.updateMarkersDict(),0==o.markers.length&&(o.options.markerLastID=0)},markerAdd:function(e,t){var o=$.extend(!0,{},markerOptions,e);if(!o.src)return!1;if(o.src=safeURL(o.src),o.width&&o.height)return i.markerAddFinalStep(o,t);var s=new Image;s.onload=function(){return o.width=this.width,o.height=this.height,i.markerAddFinalStep(o,t)},s.src=o.src},markerAddFinalStep:function(e,t){if(e.xy||isNumber(e.x)&&isNumber(e.y))xy=e.xy||[e.x,e.y],t&&(xy[0]+=o.scale<1?1:2,xy[1]+=1,xy[0]=xy[0]/o.scale-e.width/2+o.viewBox[0],xy[1]=xy[1]/o.scale-e.height+o.viewBox[1]);else{if(!e.geoCoords)return!1;xy=i.convertGeoToPixel(e.geoCoords),xy[0]=xy[0]-e.width/2+.3,xy[1]=xy[1]-e.height+1.5}e.x=xy[0],e.y=xy[1],e.id=e.id||"marker_"+o.options.markerLastID++,!e.geoCoords&&o.mapIsGeo&&(e.geoCoords=i.convertPixelToGeo(e.x+e.width/2,e.y+(e.height-1)));var s=new Marker(e,o.scale);return o.$svg.append(s.node),s.href&&s.setHref(s.href),s.adjustPosition(o.scale),o.markers.push(s),o.markersDict[s.id]=o.markers.length-1,t&&o.markerEditHandler&&o.markerEditHandler.call(s),s},markersAdjustPosition:function(){o.markers.forEach(function(e){e.adjustPosition(o.scale)})},markerMoveStart:function(){this.data("ox",parseFloat(this.attr("x"))),this.data("oy",parseFloat(this.attr("y")))},markerMove:function(e,t){e/=o.scale,t/=o.scale,this.attr({x:this.data("ox")+e,y:this.data("oy")+t})},markerMoveEnd:function(){this.data("ox")==this.attr("x")&&this.data("oy")==this.attr("y")&&t.markerEditHandler.call(this)},scrollStart:function(e,t){if($(e.target).hasClass("mapsvg-btn-zoom")||$(e.target).closest(".mapsvg-gauge").length)return!1;if(o.editMarkers.on&&"mapsvg-marker"==$(e.target).attr("class"))return!1;if(e.preventDefault(),touchDevice)var s=e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches[0]?e.originalEvent.touches[0]:e;else var s=e;o.scroll={},o.scroll.vxi=o.viewBox[0],o.scroll.vyi=o.viewBox[1],o.scroll.x=s.clientX,o.scroll.y=s.clientY,o.scroll.dx=0,o.scroll.dy=0,o.scroll.vx=0,o.scroll.vy=0,touchDevice||$("body").on("mousemove.scroll.mapsvg",i.scrollMove).on("mouseup.scroll.mapsvg",function(e){i.scrollEnd(e,t)})},scrollMove:function(e){e.preventDefault(),o.isScrolling=!0,$("body").css({cursor:"move"});var t=e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches[0]?e.originalEvent.touches[0]:e;o.scroll.dx=o.scroll.x-t.clientX,
    o.scroll.dy=o.scroll.y-t.clientY;var s=parseInt(o.scroll.vxi+o.scroll.dx/o.scale),n=parseInt(o.scroll.vyi+o.scroll.dy/o.scale);o.options.scroll.limit&&(s<o.svgDefault.viewBox[0]?s=o.svgDefault.viewBox[0]:o.viewBox[2]+s>o.svgDefault.viewBox[0]+o.svgDefault.viewBox[2]&&(s=o.svgDefault.viewBox[0]+o.svgDefault.viewBox[2]-o.viewBox[2]),n<o.svgDefault.viewBox[1]?n=o.svgDefault.viewBox[1]:o.viewBox[3]+n>o.svgDefault.viewBox[1]+o.svgDefault.viewBox[3]&&(n=o.svgDefault.viewBox[1]+o.svgDefault.viewBox[3]-o.viewBox[3])),o.scroll.vx=s,o.scroll.vy=n,i.setViewBox([o.scroll.vx,o.scroll.vy,o.viewBox[2],o.viewBox[3]])},scrollEnd:function(e,t){o.isScrolling=!1,Math.abs(o.scroll.dx)<5&&Math.abs(o.scroll.dy)<5&&(o.editMarkers.on?i.markerAddClickHandler(e):o.region_clicked&&i.regionClickHandler(e,o.region_clicked)),$("body").css({cursor:"default"}),o.viewBox[0]=o.scroll.vx||o.viewBox[0],o.viewBox[1]=o.scroll.vy||o.viewBox[1],$("body").off(".scroll.mapsvg")},scrollRegionClickHandler:function(e,t){o.region_clicked=t},touchStart:function(e,t){e.preventDefault();var s=e.originalEvent;o.options.zoom&&s.touches&&2==s.touches.length?(o.touchZoomStartViewBox=o.viewBox,o.touchZoomStart=o.scale,o.touchZoomEnd=1):(i.scrollStart(e,t),o.isScrolling=!0)},touchMove:function(e){e.preventDefault();var t=e.originalEvent;o.options.zoom&&t.touches&&t.touches.length>=2?(i.zoom(null,t.scale),o.isScrolling=!1):o.isScrolling&&i.scrollMove(e)},touchEnd:function(e){e.preventDefault();e.originalEvent;o.touchZoomStart?(o.touchZoomStart=!1,o.touchZoomEnd=!1):o.isScrolling&&i.scrollEnd(e)},markersGroupHide:function(e){for(var t in o.markers[e])o.markers[e][t].hide()},markersGroupShow:function(e){for(var t in o.markers[e])o.markers[e][t].show()},regionsGroupSelect:function(e){for(var t in o.markers[e])o.markers[e][t].hide()},regionsGroupUnselect:function(e){for(var t in o.markers[e])o.markers[e][t].show()},markersGet:function(){return o.markers},getSelected:function(){return o.selected_id},selectRegion:function(e){if("string"==typeof e)var t=i.getRegion(e);else var t=e;if(!t||t.disabled)return!1;if(o.options.multiSelect&&!o.editRegions.on){if(t.selected)return void i.deselectRegion(t)}else o.selected_id.length>0&&i.deselectRegion();o.selected_id.push(t.id),t.select()},deselectAllRegions:function(){$.each(o.selected_id,function(e,t){i.deselectRegion(i.getRegion(t))})},deselectRegion:function(e){e||(e=i.getRegion(o.selected_id[0])),e.deselect();var t=$.inArray(e.id,o.selected_id);o.selected_id.splice(t,1),_browser.ie&&i.mapAdjustStrokes()},selectRegionsGroup:function(e){for(var t in o.regionGroups[e]){var s=o.regionGroups[e][t].id;i.selectRegion(s)}},highlightRegionsGroup:function(e){for(var t in o.regionGroups[e]){var s=o.regionGroups[e][t].id;i.highlightRegion(s)}},unhighlightRegionsGroup:function(e){for(var t in o.regionGroups[e]){var s=o.regionGroups[e][t].id;i.unhighlightRegion(s)}},narrowToRegionsGroup:function(e){o.regions.forEach(function(t){t.group==e||t.disabled?t.disabledTemp&&(t.disabledTemp=!1,t.disabled=!1,$(t.node).removeClass("mapsvg-disabled")):(t.disabled=!0,t.disabledTemp=!0,$(t.node).addClass("mapsvg-disabled"))})},disableRegionsGroup:function(e){},enableAllRegionsGroups:function(){o.regions.forEach(function(e){e.disabledTemp&&(e.disabledTemp=!1,e.disabled=!1,$(e.node).removeClass("mapsvg-disabled"))})},convertGeoToPixel:function(e){var t=parseFloat(e[0]),i=parseFloat(e[1]),s=(i-o.geoViewBox.leftLon)*(o.svgDefault.width/o.mapLonDelta),t=3.14159*t/180,n=o.svgDefault.width/o.mapLonDelta*360/6.28318,r=n/2*Math.log((1+Math.sin(o.mapLatBottomDegree))/(1-Math.sin(o.mapLatBottomDegree))),a=o.svgDefault.height-(n/2*Math.log((1+Math.sin(t))/(1-Math.sin(t)))-r);return s+=o.svgDefault.viewBox[0],a+=o.svgDefault.viewBox[1],[s,a]},convertPixelToGeo:function(e,t){e-=o.svgDefault.viewBox[0],t-=o.svgDefault.viewBox[1];var i=o.svgDefault.width/o.mapLonDelta*360/(2*Math.PI),s=i/2*Math.log((1+Math.sin(o.mapLatBottomDegree))/(1-Math.sin(o.mapLatBottomDegree))),n=o.svgDefault.height+s,r=(n-t)/i,a=180/Math.PI*(2*Math.atan(Math.exp(r))-Math.PI/2),l=o.geoViewBox.leftLon+e/o.svgDefault.width*o.mapLonDelta;return[a,l]},pickGaugeColor:function(e){var t=(e-o.options.gauge.min)/o.options.gauge.maxAdjusted,i=[Math.round(o.options.gauge.colors.diffRGB.r*t+o.options.gauge.colors.lowRGB.r),Math.round(o.options.gauge.colors.diffRGB.g*t+o.options.gauge.colors.lowRGB.g),Math.round(o.options.gauge.colors.diffRGB.b*t+o.options.gauge.colors.lowRGB.b),Math.round(o.options.gauge.colors.diffRGB.a*t+o.options.gauge.colors.lowRGB.a)];return i},isRegionDisabled:function(e,t){return o.options.regions[e]&&(o.options.regions[e].disabled||"none"==t)?!0:void 0!=o.options.regions[e]&&!parseBoolean(o.options.regions[e].disabled)||!o.options.disableAll&&"none"!=t&&"labels"!=e&&"Labels"!=e?!1:!0},regionClickHandler:function(e,t){if(!t||t.disabled)return!1;if(o.region_clicked=null,"region"==t.mapsvg_type&&i.selectRegion(t.id),o.editRegions.on)return void o.regionEditHandler.call(t);i.hidePopover();var s=i.getPopoverBody(t);s&&i.showPopover(e,s),o.options.onClick&&o.options.onClick.call(t,e,i),touchDevice&&t.href&&!o.disableLinks&&(window.location.href=t.href)},fileExists:function(e){if("data"==e.substr(0,4))return!0;var t=new XMLHttpRequest;return t.open("HEAD",e,!1),t.send(),404!=t.status},getStyle:function(e,t){if(e.currentStyle)var o=e.currentStyle.margin;else if(window.getComputedStyle)if(window.getComputedStyle.getPropertyValue)var o=window.getComputedStyle(e,null).getPropertyValue(t);else var o=window.getComputedStyle(e)[t];return o},search:function(e){return results=[],e=e.toLowerCase(),o.regions.forEach(function(t){(0===t.id.toLowerCase().indexOf(e)||t.title&&0===t.title.toLowerCase().indexOf(e))&&results.push(t.id)}),results},searchMarkers:function(e){return results=[],e=e.toLowerCase(),o.markers.forEach(function(t){0===t.id.toLowerCase().indexOf(e)&&results.push(t.id)}),results},markerAddClickHandler:function(e){if($(e.target).is("image"))return!1;var t=mouseCoords(e),s=t.x-o.$map.offset().left,n=t.y-o.$map.offset().top;return $.isNumeric(s)&&$.isNumeric(n)?void i.markerAdd({xy:[s,n],group:o.editMarkers.group},!0):!1},setMarkersEditMode:function(e){o.editMarkers.on=parseBoolean(e),i.deselectAllRegions(),i.setEventHandlers()},setRegionsEditMode:function(e){o.editRegions.on=parseBoolean(e),i.deselectAllRegions(),i.setEventHandlers()},setMarkers:function(e){$.each(e,function(e,t){i.markerAdd(t)})},setEventHandler:function(){},textBr:function(e){for(var t=[],o=e.split(/\n/),i=jQuery(document.createElement("div")),s=0;s<o.length;s++)t.push(i.text(o[s]).html());return t.join("<br />")},runUserFunction:function(e){try{e()}catch(t){console.log("MapSVG user-defined function error: (line "+t.line+"): "+t.message)}},showTooltip:function(e){if(e.disabled)return!1;var t;t="global"==o.options.tooltips.priority?"function"==typeof o.options.tooltips.mode&&o.options.tooltips.mode.call(e,o.mapTip,e,i)||"off"!=o.options.tooltips.mode&&e[o.options.tooltips.mode]||e.tooltip:e.tooltip||"function"==typeof o.options.tooltips.mode&&o.options.tooltips.mode.call(e,o.mapTip,e,i)||"off"!=o.options.tooltips.mode&&e[o.options.tooltips.mode],t&&(o.mapTip.html(t),o.mapTip.addClass("mapsvg-tooltip-visible"))},getPopoverBody:function(e){var t;return t="global"==o.options.popovers.priority?"function"==typeof o.options.popovers.mode?o.options.popovers.mode.call(e,o.mapPopover,e,i):e.popover:e.popover||("function"==typeof o.options.popovers.mode?o.options.popovers.mode.call(e,o.mapPopover,e,i):null)},showPopover:function(e,t,s){if(s&&2==s.length){var n=i.getScale();s[0]=o.$map.offset().left+s[0]*n,s[1]=o.$map.offset().top+s[1]*n}else var r=mouseCoords(e),s=[r.x,r.y];if(t){o.mapPopover.contentDiv.html(t);var a=s[0]-o.mapPopover.outerWidth(!1)/2,l=s[1]-o.mapPopover.outerHeight(!1)-14;0>a&&(a=0),0>l&&(l=0),o.mapPopover.css("left",a).css("top",l),o.mapPopover.addClass("mapsvg-popover-visible")}else o.mapPopover.removeClass("mapsvg-popover-visible")},hidePopover:function(){o.mapPopover.contentDiv.empty(),o.mapPopover.removeClass("mapsvg-popover-visible"),$("body").off("mousedown.popover.mapsvg",i.popoverOffHandler),o.options.onPopoverClose&&o.options.onPopoverClose.call(i)},hideTip:function(){o.mapTip.removeClass("mapsvg-tooltip-visible")},popoverOffHandler:function(e){return $(e.target).closest(".mapsvg-popover").length?!1:void i.hidePopover()},mouseOverHandler:function(e){return this instanceof Region&&(this.selected||this.highlight()),i.showTooltip(this),o.options.mouseOver&&o.options.mouseOver.call(this,e,i)},mouseOutHandler:function(e){return this instanceof Region&&(this.selected||this.unhighlight()),i.hideTip(),o.options.mouseOut&&o.options.mouseOut.call(this,e,i)},updateOptions:function(e){$.extend(!0,o.options,e)},updateMarkersDict:function(){o.markersDict={},o.markers.forEach(function(e,t){o.markersDict[e.id]=t})},setEventHandlers:function(){if(o.$map.off(".common.mapsvg"),o.editMarkers.on){var e=touchDevice?"touchstart.common.mapsvg":"mousedown.common.mapsvg";o.$map.on(e,".mapsvg-marker",function(e){e.originalEvent.preventDefault();var t=i.getMarker($(this).attr("id")),s=mouseCoords(e);t.drag(s,o.scale,function(){o.mapIsGeo&&(this.geoCoords=i.convertPixelToGeo(this.x+this.width/2,this.y+(this.height-1))),o.markerEditHandler.call(this,!0)},function(){o.markerEditHandler.call(this)})})}if(touchDevice||(o.editMarkers.on||o.$map.on("mouseover.common.mapsvg",".mapsvg-region",function(e){var o=$(this).attr("id");i.mouseOverHandler.call(i.getRegion(o),e,i,t)}).on("mouseleave.common.mapsvg",".mapsvg-region",function(e){var o=$(this).attr("id");i.mouseOutHandler.call(i.getRegion(o),e,i,t)}),o.editRegions.on||o.$map.on("mouseover.common.mapsvg",".mapsvg-marker",function(e){var o=$(this).attr("id");i.mouseOverHandler.call(i.getMarker(o),e,i,t)}).on("mouseleave.common.mapsvg",".mapsvg-marker",function(e){var o=$(this).attr("id");i.mouseOutHandler.call(i.getMarker(o),e,i,t)})),o.options.scroll.on){var s=touchDevice?"touchstart.common.mapsvg":"mousedown.common.mapsvg";o.$map.on(s,".mapsvg-region",function(e){e.preventDefault();var t=i.getRegion($(this).attr("id"));i.scrollRegionClickHandler.call(i,e,t)}),o.$map.on(s,".mapsvg-marker",function(e){e.preventDefault();var t=i.getMarker($(this).attr("id"));i.scrollRegionClickHandler.call(i,e,t)}),touchDevice?o.$map.on("touchstart.common.mapsvg",function(e){i.touchStart(e,i)}).on("touchmove.common.mapsvg",i.touchMove).on("touchend.common.mapsvg",i.touchEnd):o.$map.on("mousedown.common.mapsvg",function(e){i.scrollStart(e,i)})}else{var s=touchDevice?"touchstart.common.mapsvg":"click.common.mapsvg";o.editMarkers.on?o.$map.on(s,function(e){i.markerAddClickHandler(e)}):(o.$map.on(s,".mapsvg-region",function(e){i.regionClickHandler.call(i,e,i.getRegion($(this).attr("id")))}),o.$map.on(s,".mapsvg-marker",function(e){i.regionClickHandler.call(i,e,i.getMarker($(this).attr("id")))}))}},init:function(e,t){if(!e.source)throw new Error("MapSVG: please provide SVG file source.");if(e.beforeLoad)try{e.beforeLoad.call(i)}catch(s){}0===e.source.indexOf("//")?e.source=e.source.replace(/^\/\/[^\/]+/,"").replace("//","/"):e.source=e.source.replace(/^.*:\/\/[^\/]+/,"").replace("//","/"),o={},o.options=$.extend(!0,{},defaults,e),o.editRegions={on:!1},o.editMarkers={on:!1},o.map=t,o.$map=$(t),o.whRatio=0,o.isScrolling=!1,o.markerOptions={},o.svgDefault={},o.refLength=0,o.scale=1,o._scale=1,o.selected_id=[],o.mapData={},o.regions=[],o.regionsDict={},o.regionID={id:0},o.markers=[],o.markersDict={},o._viewBox=[],o.viewBox=[],o.viewBoxZoom=[],o.viewBoxFind=void 0,o.zoomLevel=0,o.scroll={},o.geoCoordinates=!1,o.geoViewBox={leftLon:0,topLat:0,rightLon:0,bottomLat:0},o.$map.addClass("mapsvg").css("background",o.options.colors.background);var n=$("<div>"+o.options.loadingText+"</div>").addClass("mapsvg-loading");return o.$map.append(n),n.css({"margin-left":function(){return-($(this).outerWidth(!1)/2)+"px"},"margin-top":function(){return-($(this).outerHeight(!1)/2)+"px"}}),$.ajax({url:o.options.source,success:function(e){$data=$(e);var t=$data.find("svg");if(o.$svg=t,o.svgDefault.width=t.attr("width"),o.svgDefault.height=t.attr("height"),o.svgDefault.viewBox=t.attr("viewBox"),o.svgDefault.width&&o.svgDefault.height)o.svgDefault.width=parseFloat(o.svgDefault.width.replace(/px/g,"")),o.svgDefault.height=parseFloat(o.svgDefault.height.replace(/px/g,"")),o.svgDefault.viewBox=o.svgDefault.viewBox?o.svgDefault.viewBox.split(" "):[0,0,o.svgDefault.width,o.svgDefault.height];else{if(!o.svgDefault.viewBox)return alert("MapSVG needs width/height or viewBox parameter to be present in SVG file."),!1;o.svgDefault.viewBox=o.svgDefault.viewBox.split(" "),o.svgDefault.width=parseFloat(o.svgDefault.viewBox[2]),o.svgDefault.height=parseFloat(o.svgDefault.viewBox[3])}var s=t.attr("mapsvg:geoViewBox");if(s&&(s=s.split(" "),4==s.length)){o.mapIsGeo=!0,o.geoCoordinates=!0;var r=t.attr("mapsvg:calibratedViewBox");o.geoViewBox={leftLon:parseFloat(s[0]),topLat:parseFloat(s[1]),rightLon:parseFloat(s[2]),bottomLat:parseFloat(s[3])},o.mapLonDelta=o.geoViewBox.rightLon-o.geoViewBox.leftLon,o.mapLatBottomDegree=3.14159*o.geoViewBox.bottomLat/180}$.each(o.svgDefault.viewBox,function(e,t){o.svgDefault.viewBox[e]=parseInt(t)}),o._viewBox=4==o.options.viewBox.length&&o.options.viewBox||o.svgDefault.viewBox,$.each(o._viewBox,function(e,t){o._viewBox[e]=parseFloat(t)}),t.attr("preserveAspectRatio","xMidYMid meet"),t.attr("width","100%"),t.attr("height","100%"),o.$svg.find("path, polygon, circle, ellipse, rect").each(function(e){var t=new Region($(this),o.options,o.regionID,i);o.regions.push(t),o.regionsDict[t.id]=e,t.autoID&&(o.presentAutoID=!0)}),i.setSize(o.options.width,o.options.height,o.options.responsive),o.$map.append(t);var r=o._viewBox;i.setViewBox(r),i.setGauge();var a=o.options.markers||o.options.marks||[];i.setMarkers(a),i.setScroll(o.options.scroll),i.setZoom(o.options.zoom),o.options.tooltipsMode&&(o.options.tooltips.mode=o.options.tooltipsMode),i.setTooltips(o.options.tooltips),o.options.popover&&(o.options.popovers=o.options.popover),i.setPopovers(o.options.popovers),o.options.cursor&&i.setCursor(o.options.cursor),_browser.ie&&i.mapAdjustStrokes(),$(document).ready(function(){i.setMenu()}),i.setEventHandlers(),$("#"+o.$map.attr("id")+" [title]").each(function(){this.removeAttribute("title")}),$("#"+o.$map.attr("id")+" title").remove(),n.hide(),o.options.afterLoad&&o.options.afterLoad.call(i),i.updateSize()}}),i}};var i=this.methods},$.fn.mapSvg=function(e){var t=$(this).attr("id");return"object"==typeof e&&void 0===instances[t]?(instances[t]=new mapSVG(this,e),instances[t].methods.init(e,this)):instances[t]?instances[t].methods:instances}}(jQuery),function(e){function t(e,i){if(e=e?e:"",i=i||{},e instanceof t)return e;if(!(this instanceof t))return new t(e,i);var s=o(e);this._originalInput=e,this._r=s.r,this._g=s.g,this._b=s.b,this._a=s.a,this._roundA=T(100*this._a)/100,this._format=i.format||s.format,this._gradientType=i.gradientType,this._r<1&&(this._r=T(this._r)),this._g<1&&(this._g=T(this._g)),this._b<1&&(this._b=T(this._b)),this._ok=s.ok,this._tc_id=P++}function o(e){var t={r:0,g:0,b:0},o=1,s=!1,r=!1;return"string"==typeof e&&(e=H(e)),"object"==typeof e&&(L(e.r)&&L(e.g)&&L(e.b)?(t=i(e.r,e.g,e.b),s=!0,r="%"===String(e.r).substr(-1)?"prgb":"rgb"):L(e.h)&&L(e.s)&&L(e.v)?(e.s=M(e.s),e.v=M(e.v),t=a(e.h,e.s,e.v),s=!0,r="hsv"):L(e.h)&&L(e.s)&&L(e.l)&&(e.s=M(e.s),e.l=M(e.l),t=n(e.h,e.s,e.l),s=!0,r="hsl"),e.hasOwnProperty("a")&&(o=e.a)),o=B(o),{ok:s,format:e.format||r,r:I(255,j(t.r,0)),g:I(255,j(t.g,0)),b:I(255,j(t.b,0)),a:o}}function i(e,t,o){return{r:255*$(e,255),g:255*$(t,255),b:255*$(o,255)}}function s(e,t,o){e=$(e,255),t=$(t,255),o=$(o,255);var i,s,n=j(e,t,o),r=I(e,t,o),a=(n+r)/2;if(n==r)i=s=0;else{var l=n-r;switch(s=a>.5?l/(2-n-r):l/(n+r),n){case e:i=(t-o)/l+(o>t?6:0);break;case t:i=(o-e)/l+2;break;case o:i=(e-t)/l+4}i/=6}return{h:i,s:s,l:a}}function n(e,t,o){function i(e,t,o){return 0>o&&(o+=1),o>1&&(o-=1),1/6>o?e+6*(t-e)*o:.5>o?t:2/3>o?e+(t-e)*(2/3-o)*6:e}var s,n,r;if(e=$(e,360),t=$(t,100),o=$(o,100),0===t)s=n=r=o;else{var a=.5>o?o*(1+t):o+t-o*t,l=2*o-a;s=i(l,a,e+1/3),n=i(l,a,e),r=i(l,a,e-1/3)}return{r:255*s,g:255*n,b:255*r}}function r(e,t,o){e=$(e,255),t=$(t,255),o=$(o,255);var i,s,n=j(e,t,o),r=I(e,t,o),a=n,l=n-r;if(s=0===n?0:l/n,n==r)i=0;else{switch(n){case e:i=(t-o)/l+(o>t?6:0);break;case t:i=(o-e)/l+2;break;case o:i=(e-t)/l+4}i/=6}return{h:i,s:s,v:a}}function a(t,o,i){t=6*$(t,360),o=$(o,100),i=$(i,100);var s=e.floor(t),n=t-s,r=i*(1-o),a=i*(1-n*o),l=i*(1-(1-n)*o),u=s%6,p=[i,a,r,r,l,i][u],g=[l,i,i,a,r,r][u],c=[r,r,l,i,i,a][u];return{r:255*p,g:255*g,b:255*c}}function l(e,t,o,i){var s=[A(T(e).toString(16)),A(T(t).toString(16)),A(T(o).toString(16))];return i&&s[0].charAt(0)==s[0].charAt(1)&&s[1].charAt(0)==s[1].charAt(1)&&s[2].charAt(0)==s[2].charAt(1)?s[0].charAt(0)+s[1].charAt(0)+s[2].charAt(0):s.join("")}function u(e,t,o,i){var s=[A(O(i)),A(T(e).toString(16)),A(T(t).toString(16)),A(T(o).toString(16))];return s.join("")}function p(e,o){o=0===o?0:o||10;var i=t(e).toHsl();return i.s-=o/100,i.s=D(i.s),t(i)}function g(e,o){o=0===o?0:o||10;var i=t(e).toHsl();return i.s+=o/100,i.s=D(i.s),t(i)}function c(e){return t(e).desaturate(100)}function d(e,o){o=0===o?0:o||10;var i=t(e).toHsl();return i.l+=o/100,i.l=D(i.l),t(i)}function h(e,o){o=0===o?0:o||10;var i=t(e).toRgb();return i.r=j(0,I(255,i.r-T(255*-(o/100)))),i.g=j(0,I(255,i.g-T(255*-(o/100)))),i.b=j(0,I(255,i.b-T(255*-(o/100)))),t(i)}function f(e,o){o=0===o?0:o||10;var i=t(e).toHsl();return i.l-=o/100,i.l=D(i.l),t(i)}function v(e,o){var i=t(e).toHsl(),s=(i.h+o)%360;return i.h=0>s?360+s:s,t(i)}function m(e){var o=t(e).toHsl();return o.h=(o.h+180)%360,t(o)}function b(e){var o=t(e).toHsl(),i=o.h;return[t(e),t({h:(i+120)%360,s:o.s,l:o.l}),t({h:(i+240)%360,s:o.s,l:o.l})]}function w(e){var o=t(e).toHsl(),i=o.h;return[t(e),t({h:(i+90)%360,s:o.s,l:o.l}),t({h:(i+180)%360,s:o.s,l:o.l}),t({h:(i+270)%360,s:o.s,l:o.l})]}function x(e){var o=t(e).toHsl(),i=o.h;return[t(e),t({h:(i+72)%360,s:o.s,l:o.l}),t({h:(i+216)%360,s:o.s,l:o.l})]}function y(e,o,i){o=o||6,i=i||30;var s=t(e).toHsl(),n=360/i,r=[t(e)];for(s.h=(s.h-(n*o>>1)+720)%360;--o;)s.h=(s.h+n)%360,r.push(t(s));return r}function _(e,o){o=o||6;for(var i=t(e).toHsv(),s=i.h,n=i.s,r=i.v,a=[],l=1/o;o--;)a.push(t({h:s,s:n,v:r})),r=(r+l)%1;return a}function k(e){var t={};for(var o in e)e.hasOwnProperty(o)&&(t[e[o]]=o);return t}function B(e){return e=parseFloat(e),(isNaN(e)||0>e||e>1)&&(e=1),e}function $(t,o){R(t)&&(t="100%");var i=C(t);return t=I(o,j(0,parseFloat(t))),i&&(t=parseInt(t*o,10)/100),e.abs(t-o)<1e-6?1:t%o/parseFloat(o)}function D(e){return I(1,j(0,e))}function S(e){return parseInt(e,16)}function R(e){return"string"==typeof e&&-1!=e.indexOf(".")&&1===parseFloat(e)}function C(e){return"string"==typeof e&&-1!=e.indexOf("%")}function A(e){return 1==e.length?"0"+e:""+e}function M(e){return 1>=e&&(e=100*e+"%"),e}function O(t){return e.round(255*parseFloat(t)).toString(16)}function G(e){return S(e)/255}function L(e){return!!Y.CSS_UNIT.exec(e)}function H(e){e=e.replace(F,"").replace(E,"").toLowerCase();var t=!1;if(N[e])e=N[e],t=!0;else if("transparent"==e)return{r:0,g:0,b:0,a:0,format:"name"};var o;return(o=Y.rgb.exec(e))?{r:o[1],g:o[2],b:o[3]}:(o=Y.rgba.exec(e))?{r:o[1],g:o[2],b:o[3],a:o[4]}:(o=Y.hsl.exec(e))?{h:o[1],s:o[2],l:o[3]}:(o=Y.hsla.exec(e))?{h:o[1],s:o[2],l:o[3],a:o[4]}:(o=Y.hsv.exec(e))?{h:o[1],s:o[2],v:o[3]}:(o=Y.hsva.exec(e))?{h:o[1],s:o[2],v:o[3],a:o[4]}:(o=Y.hex8.exec(e))?{a:G(o[1]),r:S(o[2]),g:S(o[3]),b:S(o[4]),format:t?"name":"hex8"}:(o=Y.hex6.exec(e))?{r:S(o[1]),g:S(o[2]),b:S(o[3]),format:t?"name":"hex"}:(o=Y.hex3.exec(e))?{r:S(o[1]+""+o[1]),g:S(o[2]+""+o[2]),b:S(o[3]+""+o[3]),format:t?"name":"hex"}:!1}function z(e){var t,o;return e=e||{level:"AA",size:"small"},t=(e.level||"AA").toUpperCase(),o=(e.size||"small").toLowerCase(),"AA"!==t&&"AAA"!==t&&(t="AA"),"small"!==o&&"large"!==o&&(o="small"),{level:t,size:o}}var F=/^\s+/,E=/\s+$/,P=0,T=e.round,I=e.min,j=e.max,V=e.random;t.prototype={isDark:function(){return this.getBrightness()<128},isLight:function(){return!this.isDark()},isValid:function(){return this._ok},getOriginalInput:function(){return this._originalInput},getFormat:function(){return this._format},getAlpha:function(){return this._a},getBrightness:function(){var e=this.toRgb();return(299*e.r+587*e.g+114*e.b)/1e3},getLuminance:function(){var t,o,i,s,n,r,a=this.toRgb();return t=a.r/255,o=a.g/255,i=a.b/255,s=.03928>=t?t/12.92:e.pow((t+.055)/1.055,2.4),n=.03928>=o?o/12.92:e.pow((o+.055)/1.055,2.4),r=.03928>=i?i/12.92:e.pow((i+.055)/1.055,2.4),.2126*s+.7152*n+.0722*r},setAlpha:function(e){return this._a=B(e),this._roundA=T(100*this._a)/100,this},toHsv:function(){var e=r(this._r,this._g,this._b);return{h:360*e.h,s:e.s,v:e.v,a:this._a}},toHsvString:function(){var e=r(this._r,this._g,this._b),t=T(360*e.h),o=T(100*e.s),i=T(100*e.v);return 1==this._a?"hsv("+t+", "+o+"%, "+i+"%)":"hsva("+t+", "+o+"%, "+i+"%, "+this._roundA+")"},toHsl:function(){var e=s(this._r,this._g,this._b);return{h:360*e.h,s:e.s,l:e.l,a:this._a}},toHslString:function(){var e=s(this._r,this._g,this._b),t=T(360*e.h),o=T(100*e.s),i=T(100*e.l);return 1==this._a?"hsl("+t+", "+o+"%, "+i+"%)":"hsla("+t+", "+o+"%, "+i+"%, "+this._roundA+")"},toHex:function(e){return l(this._r,this._g,this._b,e)},toHexString:function(e){return"#"+this.toHex(e)},toHex8:function(){return u(this._r,this._g,this._b,this._a)},toHex8String:function(){return"#"+this.toHex8()},toRgb:function(){return{r:T(this._r),g:T(this._g),b:T(this._b),a:this._a}},toRgbString:function(){return 1==this._a?"rgb("+T(this._r)+", "+T(this._g)+", "+T(this._b)+")":"rgba("+T(this._r)+", "+T(this._g)+", "+T(this._b)+", "+this._roundA+")"},toPercentageRgb:function(){return{r:T(100*$(this._r,255))+"%",g:T(100*$(this._g,255))+"%",b:T(100*$(this._b,255))+"%",a:this._a}},toPercentageRgbString:function(){return 1==this._a?"rgb("+T(100*$(this._r,255))+"%, "+T(100*$(this._g,255))+"%, "+T(100*$(this._b,255))+"%)":"rgba("+T(100*$(this._r,255))+"%, "+T(100*$(this._g,255))+"%, "+T(100*$(this._b,255))+"%, "+this._roundA+")"},toName:function(){return 0===this._a?"transparent":this._a<1?!1:X[l(this._r,this._g,this._b,!0)]||!1},toFilter:function(e){var o="#"+u(this._r,this._g,this._b,this._a),i=o,s=this._gradientType?"GradientType = 1, ":"";if(e){var n=t(e);i=n.toHex8String()}return"progid:DXImageTransform.Microsoft.gradient("+s+"startColorstr="+o+",endColorstr="+i+")"},toString:function(e){var t=!!e;e=e||this._format;var o=!1,i=this._a<1&&this._a>=0,s=!t&&i&&("hex"===e||"hex6"===e||"hex3"===e||"name"===e);return s?"name"===e&&0===this._a?this.toName():this.toRgbString():("rgb"===e&&(o=this.toRgbString()),"prgb"===e&&(o=this.toPercentageRgbString()),("hex"===e||"hex6"===e)&&(o=this.toHexString()),"hex3"===e&&(o=this.toHexString(!0)),"hex8"===e&&(o=this.toHex8String()),"name"===e&&(o=this.toName()),"hsl"===e&&(o=this.toHslString()),"hsv"===e&&(o=this.toHsvString()),o||this.toHexString())},clone:function(){return t(this.toString())},_applyModification:function(e,t){var o=e.apply(null,[this].concat([].slice.call(t)));return this._r=o._r,this._g=o._g,this._b=o._b,this.setAlpha(o._a),this},lighten:function(){return this._applyModification(d,arguments)},brighten:function(){return this._applyModification(h,arguments)},darken:function(){return this._applyModification(f,arguments)},desaturate:function(){return this._applyModification(p,arguments)},saturate:function(){return this._applyModification(g,arguments)},greyscale:function(){return this._applyModification(c,arguments)},spin:function(){return this._applyModification(v,arguments)},_applyCombination:function(e,t){return e.apply(null,[this].concat([].slice.call(t)))},analogous:function(){return this._applyCombination(y,arguments)},complement:function(){return this._applyCombination(m,arguments)},monochromatic:function(){return this._applyCombination(_,arguments)},splitcomplement:function(){return this._applyCombination(x,arguments)},triad:function(){return this._applyCombination(b,arguments)},tetrad:function(){return this._applyCombination(w,arguments)}},t.fromRatio=function(e,o){if("object"==typeof e){var i={};for(var s in e)e.hasOwnProperty(s)&&("a"===s?i[s]=e[s]:i[s]=M(e[s]));e=i}return t(e,o)},t.equals=function(e,o){return e&&o?t(e).toRgbString()==t(o).toRgbString():!1},t.random=function(){return t.fromRatio({r:V(),g:V(),b:V()})},t.mix=function(e,o,i){i=0===i?0:i||50;var s,n=t(e).toRgb(),r=t(o).toRgb(),a=i/100,l=2*a-1,u=r.a-n.a;s=l*u==-1?l:(l+u)/(1+l*u),s=(s+1)/2;var p=1-s,g={r:r.r*s+n.r*p,g:r.g*s+n.g*p,b:r.b*s+n.b*p,a:r.a*a+n.a*(1-a)};return t(g)},t.readability=function(o,i){var s=t(o),n=t(i);return(e.max(s.getLuminance(),n.getLuminance())+.05)/(e.min(s.getLuminance(),n.getLuminance())+.05)},t.isReadable=function(e,o,i){var s,n,r=t.readability(e,o);switch(n=!1,s=z(i),s.level+s.size){case"AAsmall":case"AAAlarge":n=r>=4.5;break;case"AAlarge":n=r>=3;break;case"AAAsmall":n=r>=7}return n},t.mostReadable=function(e,o,i){var s,n,r,a,l=null,u=0;i=i||{},n=i.includeFallbackColors,r=i.level,a=i.size;for(var p=0;p<o.length;p++)s=t.readability(e,o[p]),s>u&&(u=s,l=t(o[p]));return t.isReadable(e,l,{level:r,size:a})||!n?l:(i.includeFallbackColors=!1,t.mostReadable(e,["#fff","#000"],i))};var N=t.names={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"0ff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"00f",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",burntsienna:"ea7e5d",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"0ff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"f0f",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"},X=t.hexNames=k(N),Y=function(){var e="[-\\+]?\\d+%?",t="[-\\+]?\\d*\\.\\d+%?",o="(?:"+t+")|(?:"+e+")",i="[\\s|\\(]+("+o+")[,|\\s]+("+o+")[,|\\s]+("+o+")\\s*\\)?",s="[\\s|\\(]+("+o+")[,|\\s]+("+o+")[,|\\s]+("+o+")[,|\\s]+("+o+")\\s*\\)?";return{CSS_UNIT:new RegExp(o),rgb:new RegExp("rgb"+i),rgba:new RegExp("rgba"+s),hsl:new RegExp("hsl"+i),hsla:new RegExp("hsla"+s),hsv:new RegExp("hsv"+i),hsva:new RegExp("hsva"+s),hex3:/^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex6:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,hex8:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/}}();"undefined"!=typeof module&&module.exports?module.exports=t:"function"==typeof define&&define.amd?define(function(){return t}):window.tinycolor=t}(Math);