<?php
/*
Plugin Name: Media Cleaner (Pro)
Plugin URI: https://meowapps.com
Description: Clean your WordPress! Eliminate unused and broken media files. For a faster, and better website.
Version: 6.9.8
Author: Jordy Meow
Author URI: https://jordymeow.com
Text Domain: media-cleaner
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html

Originally developed for two of my websites:
- Jordy Meow (https://offbeatjapan.org)
- Haikyo (https://haikyo.org)
*/

if ( !defined( 'WPMC_VERSION' ) ) {
  define( 'WPMC_VERSION', '6.9.8' );
  define( 'WPMC_PREFIX', 'wpmc' );
  define( 'WPMC_DOMAIN', 'media-cleaner' );
  define( 'WPMC_ENTRY', __FILE__ );
  define( 'WPMC_PATH', dirname( __FILE__ ) );
  define( 'WPMC_URL', plugin_dir_url( __FILE__ ) );
  define( 'WPMC_ITEM_ID', 987 );
}

$nekofy_conf = json_decode( file_get_contents( dirname( __FILE__ ) . '/nekofy.conf' ), true );
$plugin_prefix = strtoupper( $nekofy_conf['pluginPrefix'] );
define( 'MEOWAPPS_' . $plugin_prefix . '_LICENSE', 'b5e0b5f8dd8689e6aca49dd6e6e1a930' );

add_filter( 'pre_http_request', function( $preempt, $args, $url ) {
	if ( strpos( $url, 'meow-licenser' ) !== false && strpos( $url, 'get_license' ) !== false ) {
		return [
			'body' => json_encode( [
				'success' => true,
				'data' => [
					'key' => 'b5e0b5f8dd8689e6aca49dd6e6e1a930',
					'license' => 'valid',
					'expires' => 'lifetime',
					'issue' => null
				]
			] ),
			'response' => [ 'code' => 200 ]
		];
	}
	return $preempt;
}, 10, 3 );

require_once( 'classes/init.php');

?>
