<?php
/**
 * Gateway: Paypal Express - Order Helper
 *
 * @since 1.5.0
 *
 * @package MemberDash
 */

/**
 * PayPal Express gateway Order helper class.
 *
 * @since 1.5.0
 */
class MS_Gateway_Paypalexpress_Helpers_Order extends MS_Helper {
	/**
	 * Returns a MemberDash subscription from a PayPal order ID.
	 *
	 * @since 1.5.0
	 *
	 * @param string $paypal_order_id The PayPal order ID.
	 * @param string $status          The subscription status. Default 'valid'.
	 *
	 * @return MS_Model_Relationship|null
	 */
	public static function get_ms_subscription( string $paypal_order_id, string $status = 'valid' ) {
		$ids = MS_Model_Relationship::get_subscription_ids(
			[
				'status'     => $status,
				'meta_query' => [
					[
						'key'     => 'ms_gateway_paypal_order_id',
						'value'   => $paypal_order_id,
						'compare' => '=',
					],
				],
			]
		);

		if ( ! empty( $ids[0] ) ) {
			return MS_Factory::load(
				'MS_Model_Relationship',
				$ids[0]
			);
		}

		return null;
	}

	/**
	 * Returns the status from a PayPal order.
	 *
	 * @since 1.5.0
	 *
	 * @param array<string,mixed> $data The PayPal order data.
	 *
	 * @return string
	 */
	public static function get_order_status( array $data ): string {
		$captures = [];

		$status = isset( $data['status'] )
			? $data['status']
			: '';

		$purchase_units = [];
		if (
			isset( $data['purchase_units'] )
			&& is_array( $data['purchase_units'] )
		) {
			$purchase_units = $data['purchase_units'];
		}

		foreach ( $purchase_units as $unit ) {
			if ( ! empty( $unit['payments']['captures'] ) ) {
				$captures[] = $unit['payments']['captures'];
			}
		}

		if (
			'CREATED' === $status
			&& ! empty( $captures )
		) {
			$captures = array_shift( $captures );
			if ( count( $captures ) > 1 ) {
				usort(
					$captures,
					function ( $a, $b ) {
						return strtotime( $a['update_time'] ) <=> strtotime( $b['update_time'] );
					}
				);
			}

			foreach ( $captures as $capture ) {
				$status = $capture['status'];
				$final  = $capture['final_capture'] ?? false;

				if ( $final ) {
					break;
				}
			}
		}

		return $status;
	}
}
