<?php
/**
 * Gateway: Paypal Express - Helpers
 *
 * @since 1.5.0
 *
 * @package MemberDash
 */

/**
 * PayPal Express gateway Helpers class.
 *
 * @since 1.5.0
 */
class MS_Gateway_Paypalexpress_Helpers extends MS_Helper {
	/**
	 * Returns a formatted text limited to 127 characters.
	 *
	 * @since 1.5.0
	 *
	 * @param string $text                 The text to format.
	 * @param int    $max_character_length The maximum character length.
	 *
	 * @return string
	 */
	public static function trim_text( string $text, int $max_character_length = 127 ): string {
		$ellipsis             = '...';
		$truncate_length      = $max_character_length - strlen( $ellipsis );

		if ( strlen( $text ) <= $max_character_length ) {
			return $text;
		}

		// Cut the text to the desired length.
		$truncated_text = substr( $text, 0, $truncate_length );

		// Find the last space within the truncated text.
		$last_space = strrpos( $truncated_text, ' ' );

		// Cut the text at the last space to avoid cutting in the middle of a word.
		if ( $last_space !== false ) {
			$truncated_text = substr( $truncated_text, 0, $last_space );
		}

		// Add an ellipsis at the end.
		$truncated_text .= $ellipsis;

		return $truncated_text;
	}

	/**
	 * Returns the cancel URL for a membership.
	 *
	 * @since 1.5.0
	 *
	 * @param int $membership_id The membership ID.
	 *
	 * @return string
	 */
	public static function get_cancel_url( int $membership_id ): string {
		if ( is_user_logged_in() ) {
			$current = MS_Model_Pages::MS_PAGE_MEMBERSHIPS;
		} else {
			$current = MS_Model_Pages::MS_PAGE_REGISTER;
		}

		$url = MS_Model_Pages::get_page_url( $current );

		return esc_url_raw(
			add_query_arg(
				[
					'_wpnonce'      => wp_create_nonce( MS_Helper_Membership::MEMBERSHIP_ACTION_CANCEL ),
					'membership_id' => $membership_id,
					'action'        => 'membership_cancel',
				],
				$url
			)
		);
	}
}
