<?php
/**
 * Gateway: Paypal Express - Connected Dialog View
 *
 * @since 1.5.0
 *
 * @package MemberDash
 */

/**
 * PayPal Express gateway connected view class.
 *
 * @since 1.5.0
 */
class MS_Gateway_Paypalexpress_View_Connected extends MS_View {
	/**
	 * Returns the HTML for the connected dialog.
	 *
	 * @since 1.5.0
	 *
	 * @return string
	 */
	public function to_html() {
		$sandbox = $this->data['sandbox'];

		ob_start();
		?>
		<div class="ms-paypal-express-gateway-connected" style="display: none;">
			<h2><?php esc_html_e( 'You are now connected to PayPal, here\'s what\'s next...', 'memberdash' ); ?></h2>

			<?php if ( $sandbox ) : ?>
				<p class="ms-bg-red-300 ms-p-5 ms-text-gray-800">
					<?php esc_html_e( 'You have connected your account for test mode. You will need to connect again once you are in live mode.', 'memberdash' ); ?>
				</p>
			<?php endif; ?>

			<p>
				<?php esc_html_e( 'PayPal allows you to accept credit or debit cards directly on your website. Because of this, your site needs to maintain PCI-DSS compliance.', 'memberdash' ); ?>
			</p>

			<p>
				<?php esc_html_e( 'MemberDash never stores sensitive information like card details to your server and works seamlessly with SSL certificates.', 'memberdash' ); ?>
			</p>

			<p>
				<?php esc_html_e( 'Compliance is comprised of, but not limited to:', 'memberdash' ); ?>
			</p>

			<ul class="ms-list-disc">
				<li class="ms-ml-4">
					<?php esc_html_e( 'Using a trusted, secure hosting provider &mdash; preferably one which claims and actively promotes PCI compliance.', 'memberdash' ); ?>
				</li>

				<li class="ms-ml-4">
					<?php esc_html_e( 'Maintain security best practices when setting passwords and limit access to your server.', 'memberdash' ); ?>
				</li>

				<li class="ms-ml-4">
					<?php esc_html_e( 'Implement an SSL certificate to keep your ticket sales secure.', 'memberdash' ); ?>
				</li>

				<li class="ms-ml-4">
					<?php esc_html_e( 'Keep WordPress and plugins up to date to ensure latest security fixes are present.', 'memberdash' ); ?>
				</li>
			</ul>

			<?php
			MS_Helper_Html::html_element(
				[
					'id'    => 'ms-paypal-express-gateway-connected-close',
					'type'  => MS_Helper_Html::TYPE_HTML_LINK,
					'class' => 'button button-primary ms-bg-black ms-border-black ms-text-white ms-shadow-none ms-text-center ms-mt-5',
					'value' => __( 'Got it, thanks!', 'memberdash' ),
					'url'   => esc_url(
						add_query_arg(
							[
								'tab'                   => 'payment',
								'closed'                => 'true',
								'paypal-express-notice' => 'connected',
							],
							MS_Controller_Plugin::get_admin_url( 'settings' )
						)
					),
				]
			);
			?>
		</div>
		<?php
		return MS_Helper_Cast::to_string( ob_get_clean() );
	}
}
