<?php
/**
 * Stripe Card View.
 *
 * @since 1.0.0
 *
 * @package MemberDash
 */

/**
 * Stripe Card View class.
 *
 * Display all user cards and allow to update.
 *
 * @since 1.0.0
 */
class MS_Gateway_Stripe_View_Card extends MS_View {
	/**
	 * Render the view.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function to_html() {
		ob_start();
		?>
			<div id="account-stripe-payment-details" class="ms-wrap">
				<h2><?php esc_html_e( 'Payment Details', 'memberdash' ); ?></h2>
				<div id="error-message"></div>
				<p>
					<?php
						printf(
							/* translators: %s - Stripe URL. */
							esc_html__( 'You can manage your payment details on %s.', 'memberdash' ),
							'<a href="#" id="stripe-customer-portal" target="_blank">' . esc_html__( 'Stripe', 'memberdash' ) . '</a>'
						)
					?>
				</p>
			</div>
		<?php
		$html = ob_get_clean();
		return $html;
	}
}
