<?php
/**
 * Notices model.
 *
 * @since 1.3.1
 *
 * @package MemberDash
 */

/**
 * Notices model.
 *
 * @since 1.3.1
 */
class MS_Model_Notices extends MS_Model {

	/**
	 * Meta key for user notices.
	 *
	 * @since 1.3.1
	 *
	 * @var string
	 */
	const USER_META_KEY = 'ms_user_notices';

	/**
	 * Gets user notices.
	 *
	 * @since 1.3.1
	 *
	 * @param int $user_id User ID.
	 *
	 * @return array<string,string>
	 */
	public function get_user_notices( int $user_id ): array {
		$notices = get_user_meta( $user_id, self::USER_META_KEY, true );

		if ( ! is_array( $notices ) ) {
			$notices = [];
		}

		/**
		 * Filter user notices.
		 *
		 * @since 1.3.1
		 *
		 * @param array            $notices User notices.
		 * @param int              $user_id User ID.
		 * @param MS_Model_Notices $model   Notices model.
		 *
		 * @return array<string,string>
		 */
		return apply_filters(
			'ms_model_user_notices',
			$notices,
			$user_id,
			$this
		);
	}

	/**
	 * Updates user notices.
	 *
	 * @since 1.3.1
	 *
	 * @param int                  $user_id User ID.
	 * @param array<string,string> $notices Notices.
	 *
	 * @return void
	 */
	public function update_user_notices( int $user_id, array $notices ): void {
		update_user_meta( $user_id, self::USER_META_KEY, $notices );
	}
}
