<?php
/**
 * Trait support base rule management.
 *
 * @since 1.1.3
 *
 * @package MemberDash
 */

namespace Memberdash\Rule\Traits;

use MS_Model_Membership;

/**
 * Trait support base rule management.
 *
 * @since 1.1.3
 */
trait SupportsBaseRuleManagement {
	/**
	 * Override set_memberships to allow resetting the menu base rule.
	 *
	 * @since 1.1.3
	 *
	 * @param string $id          The content id to check.
	 * @param int[]  $memberships The memberships to check.
	 *
	 * @return void
	 */
	public function set_memberships( $id, $memberships ) {
		parent::set_memberships( $id, $memberships );

		if (
			! $this->is_base_rule
			|| ! empty( $memberships )
		) {
			return;
		}

		$membership = MS_Model_Membership::get_base();
		$rule       = $membership->get_rule( $this->rule_type );

		$rule->reset_rule_values();
		$membership->set_rule( $this->rule_type, $rule );
		$membership->save();
	}
}
