<?php
/**
 * Sale Banner View.
 *
 * @since 1.4.5
 *
 * @package MemberDash
 */

/**
 * Sale Banner View class.
 *
 * @since 1.4.5
 */
class MS_View_Banner extends MS_View {
	/**
	 * Renders the sale banner.
	 *
	 * Inherited from MS_View.
	 *
	 * @since 1.4.5
	 *
	 * @return string
	 */
	public function to_html() {
		ob_start();
		?>
			<div
				class="ms-sale-banner"
			>
				<a
					href="<?php echo esc_url( $this->data['link'] ); ?>"
					target="_blank"
				>
					<picture>
						<source
							srcset="<?php echo esc_url( $this->get_svg_url( 'full' ) ); ?>"
							media="(min-width: 1200px)"
						>
						<source
							srcset="<?php echo esc_url( $this->get_svg_url( 'regular' ) ); ?>"
							media="(min-width: 1100px)"
						>
						<source
							srcset="<?php echo esc_url( $this->get_svg_url( 'mobile' ) ); ?>"
							media="(min-width: 450px)"
						>
						<img
							class="ms-sale-banner-image"
							src="<?php echo esc_url( $this->get_svg_url( 'full' ) ); ?>"
							alt="<?php echo esc_attr( $this->data['description'] ); ?>"
						>
					</picture>
				</a>
				<button
					class="ms-sale-banner-close notice-dismiss"
					data-notice-id="<?php echo esc_attr( $this->data['id'] ); ?>"
					aria-label="<?php esc_attr_e( 'Close', 'memberdash' ); ?>"
				>
					<img
						src="<?php echo esc_url( $this->get_svg_url( 'close' ) ); ?>"
						alt="<?php esc_html_e( 'Close button', 'memberdash' ); ?>"
					>
				</button>
			</div>
		<?php
		return MS_Helper_Cast::to_string( ob_get_clean() );
	}

	/**
	 * Returns the SVG image URL.
	 *
	 * @since 1.4.5
	 *
	 * @param string $size The image size.
	 *
	 * @return string
	 */
	protected function get_svg_url( string $size = 'full' ): string {
		return sprintf(
			'%s/app/assets/images/settings/banners/%s/%s.svg',
			MS_Plugin::instance()->get_url(),
			$this->data['id'],
			$size
		);
	}
}
