<?php
/**
 * Implement uniform data storage and sharing among all child classes.
 *
 * @since 1.0.0
 */
abstract class MsTheLib {

	/**
	 * Internal data collection used to pass arguments to callback functions.
	 * Only used for 5.2 version as alternative to closures.
	 *
	 * @var array
	 * @internal
	 */
	static protected $data = array();

	/**
	 * Back-reference to the main component: TheLib_Core
	 *
	 * @var TheLib_Core
	 * @internal
	 */
	static protected $core = null;


	/**
	 * Checks if a key exists in the request-cache.
	 *
	 * @since 1.0.0
	 * @internal
	 *
	 * @param  string $key The key to check
	 * @return bool
	 */
	protected function _have( $key ) {
		return isset( self::$data[ $key ] );
	}

	/**
	 * Request cache
	 *
	 * @since 1.0.0
	 * @internal
	 *
	 * @param  string $key
	 * @param  mixed $value
	 */
	protected function _add( $key, $value ) {
		if ( ! isset( self::$data[ $key ] )
			|| ! is_array( self::$data[ $key ] )
		) {
			self::$data[ $key ] = array();
		}

		self::$data[ $key ][] = $value;
	}

	/**
	 * Request cache
	 *
	 * @since 1.0.0
	 * @internal
	 *
	 * @param  string $key
	 * @return mixed
	 */
	protected function _get( $key ) {
		if ( ! isset( self::$data[ $key ] )
			|| ! is_array( self::$data[ $key ] )
		) {
			self::$data[ $key ] = array();
		}

		return self::$data[ $key ];
	}

	/**
	 * Request cache
	 *
	 * @since 1.0.0
	 * @internal
	 *
	 * @param  string $key
	 */
	protected function _clear( $key ) {
		self::$data[ $key ] = array();
	}

	/**
	 * Base constructor.
	 *
	 * @since 1.1.0
	 * @internal
	 */
	public function __construct() {
		self::_init_const();
	}

	/**
	 * Initializes missing module-flags with default values.
	 *
	 * @since 1.0.0
	 * @internal
	 */
	static protected function _init_const() {
		if ( ! defined( 'WDEV_UNMINIFIED' ) ) {
			define( 'WDEV_UNMINIFIED', false );
		}

		if ( ! defined( 'WDEV_DEBUG' ) ) {
			if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) {
				define( 'WDEV_DEBUG', true );
			} else {
				define( 'WDEV_DEBUG', false );
			}
		}

		if ( ! defined( 'WDEV_AJAX_DEBUG' ) ) {
			define( 'WDEV_AJAX_DEBUG', WDEV_DEBUG );
		}
	}

	/**
	 * Returns the full URL to an internal CSS file of the code library.
	 *
	 * @since 1.0.0
	 * @internal
	 *
	 * @param  string $file The filename, relative to this plugins folder.
	 * @return string
	 */
	protected function _css_url( $file ) {
		static $Url = null;

		if ( WDEV_UNMINIFIED ) {
			$file = str_replace( '.min.css', '.css', $file );
		}
		if ( null === $Url ) {
			$Url = plugins_url( 'css/', dirname( __FILE__ ) );
		}

		return $Url . $file;
	}

	/**
	 * Returns the full URL to an internal JS file of the code library.
	 *
	 * @since 1.0.0
	 * @internal
	 *
	 * @param  string $file The filename, relative to this plugins folder.
	 * @return string
	 */
	protected function _js_url( $file ) {
		static $Url = null;

		if ( WDEV_UNMINIFIED ) {
			$file = str_replace( '.min.js', '.js', $file );
		}
		if ( null === $Url ) {
			$Url = plugins_url( 'js/', dirname( __FILE__ ) );
		}

		return $Url . $file;
	}

	/**
	 * Returns the full path to an internal php partial of the code library.
	 *
	 * @since 1.0.0
	 * @internal
	 *
	 * @param  string $file The filename, relative to this plugins folder.
	 * @return string
	 */
	protected function _view_path( $file ) {
		static $Path = null;

		if ( null === $Path ) {
			$basedir = dirname( dirname( __FILE__ ) ) . '/';
			$Path = $basedir . 'view/';
		}

		return $Path . $file;
	}

	/**
	 * Adds or executes an action.
	 *
	 * @since 1.1.3
	 * @api
	 *
	 * @param string $tag      The action-name.
	 * @param string $function Function name (must be a class function)
	 * @param int    $priority Execution priority. Lower is earlier.
	 *
	 * @return void
	 */
	protected function add_action( $tag, $function, $priority = 10 ) {
		if ( did_action( $tag ) ) {
			$this->$function();
		} else {
			add_action( $tag, array( $this, $function ), $priority );
		}
	}
}
