<?php
/**
 * Handles setting up a base for all subscribers.
 *
 * @package StellarWP\Memberdash\StellarWP\Telemetry\Contracts
 *
 * @license GPL-2.0-or-later
 * Modified by memberdash on 27-October-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace StellarWP\Memberdash\StellarWP\Telemetry\Contracts;

use StellarWP\Memberdash\StellarWP\ContainerContract\ContainerInterface;

/**
 * Class Abstract_Subscriber
 *
 * @package StellarWP\Memberdash\StellarWP\Telemetry\Contracts
 */
abstract class Abstract_Subscriber implements Subscriber_Interface {

	/**
	 * @var ContainerInterface
	 */
	protected $container;

	/**
	 * Constructor for the class.
	 *
	 * @param ContainerInterface $container The container.
	 */
	public function __construct( ContainerInterface $container ) {
		$this->container = $container;
	}
}
