<?php
/**
 * @license MIT
 *
 * Modified by memberdash on 27-October-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace StellarWP\Memberdash\Stripe\ApiOperations;

/**
 * Trait for listable resources. Adds a `all()` static method to the class.
 *
 * This trait should only be applied to classes that derive from StripeObject.
 */
trait All
{
    /**
     * @param null|array $params
     * @param null|array|string $opts
     *
     * @throws \StellarWP\Memberdash\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \StellarWP\Memberdash\Stripe\Collection of ApiResources
     */
    public static function all($params = null, $opts = null)
    {
        self::_validateParams($params);
        $url = static::classUrl();

        list($response, $opts) = static::_staticRequest('get', $url, $params, $opts);
        $obj = \StellarWP\Memberdash\Stripe\Util\Util::convertToStripeObject($response->json, $opts);
        if (!($obj instanceof \StellarWP\Memberdash\Stripe\Collection)) {
            throw new \StellarWP\Memberdash\Stripe\Exception\UnexpectedValueException(
                'Expected type ' . \StellarWP\Memberdash\Stripe\Collection::class . ', got "' . \get_class($obj) . '" instead.'
            );
        }
        $obj->setLastResponse($response);
        $obj->setFilters($params);

        return $obj;
    }
}
