<?php
/**
 * @license MIT
 *
 * Modified by memberdash on 27-October-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace StellarWP\Memberdash\Stripe\Exception\OAuth;

/**
 * Implements properties and methods common to all (non-SPL) Stripe OAuth
 * exceptions.
 */
abstract class OAuthErrorException extends \StellarWP\Memberdash\Stripe\Exception\ApiErrorException
{
    protected function constructErrorObject()
    {
        if (null === $this->jsonBody) {
            return null;
        }

        return \StellarWP\Memberdash\Stripe\OAuthErrorObject::constructFrom($this->jsonBody);
    }
}
