<?php

// File generated from our OpenAPI spec

namespace StellarWP\Memberdash\Stripe\Service;

class BalanceService extends \StellarWP\Memberdash\Stripe\Service\AbstractService
{
    /**
     * Retrieves the current account balance, based on the authentication that was used
     * to make the request.  For a sample request, see <a
     * href="/docs/connect/account-balances#accounting-for-negative-balances">Accounting
     * for negative balances</a>.
     *
     * @param null|array $params
     * @param null|array|\StellarWP\Memberdash\Stripe\Util\RequestOptions $opts
     *
     * @throws \StellarWP\Memberdash\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \StellarWP\Memberdash\Stripe\Balance
     *
     * @license MIT
     * Modified by memberdash on 27-October-2025 using Strauss.
     * @see https://github.com/BrianHenryIE/strauss
     */
    public function retrieve($params = null, $opts = null)
    {
        return $this->request('get', '/v1/balance', $params, $opts);
    }
}
