<?php

// File generated from our OpenAPI spec

namespace StellarWP\Memberdash\Stripe\Service\Tax;

class SettingsService extends \StellarWP\Memberdash\Stripe\Service\AbstractService
{
    /**
     * Retrieves Tax <code>Settings</code> for a merchant.
     *
     * @param null|array $params
     * @param null|array|\StellarWP\Memberdash\Stripe\Util\RequestOptions $opts
     *
     * @throws \StellarWP\Memberdash\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \StellarWP\Memberdash\Stripe\Tax\Settings
     *
     * @license MIT
     * Modified by memberdash on 27-October-2025 using Strauss.
     * @see https://github.com/BrianHenryIE/strauss
     */
    public function retrieve($params = null, $opts = null)
    {
        return $this->request('get', '/v1/tax/settings', $params, $opts);
    }

    /**
     * Updates Tax <code>Settings</code> parameters used in tax calculations. All
     * parameters are editable but none can be removed once set.
     *
     * @param null|array $params
     * @param null|array|\StellarWP\Memberdash\Stripe\Util\RequestOptions $opts
     *
     * @throws \StellarWP\Memberdash\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \StellarWP\Memberdash\Stripe\Tax\Settings
     */
    public function update($params = null, $opts = null)
    {
        return $this->request('post', '/v1/tax/settings', $params, $opts);
    }
}
