/**
 * Stripe - Admin scripts.
 *
 * @since 1.5.0
 */
/*global memberdashLi:false */
/*global msStripeAdmin:false */

jQuery(function ($) {
	$('.gateway-stripe #stripe_disconnect_button').on('click', function (evt) {
		evt.preventDefault();

		const self = $(this);

		self.addClass('memberdash-loading');

		memberdashLi.confirm({
			message: msStripeAdmin.disconnect.message,
			buttons: [
				msStripeAdmin.disconnect.btn_disconnect,
				msStripeAdmin.disconnect.btn_cancel,
			],
			callback(key) {
				if (key !== 0) {
					self.removeClass('memberdash-loading');
					return;
				}

				window.location = self.attr('href');
			},
		});
	});
});
