<?php
/**
 * PayPal Express Button View Class
 *
 * @since 1.5.0
 *
 * @package MemberDash
 */

/**
 * PayPal Express Button View Class
 *
 * @since 1.5.0
 */
class MS_Gateway_Paypalexpress_View_Button extends MS_View {
	/**
	 * Returns the HTML for the button.
	 *
	 * Inherited from MS_View.
	 *
	 * @since 1.5.0
	 *
	 * @return string
	 */
	public function to_html() {
		$subscription = $this->data['ms_relationship'];
		$gateway      = $this->data['gateway'];
		$plan_id      = $this->data['plan_id'];

		$row_class  = 'gateway_' . $gateway->get_id();
		$row_class .= ' ms-gateway-paypalexpress-checkout';
		if ( ! $gateway->is_live_mode() ) {
			$row_class .= ' sandbox-mode';
		}

		ob_start();
		?>
		<tr class="<?php echo esc_attr( $row_class ); ?>">
			<td class="ms-buy-now-column" colspan="2">
				<div
					id="ms-gateway-paypalexpress-buttons"
					class="ms-gateway-paypalexpress-buttons-wrapper"
					data-subscription-id="<?php echo esc_attr( $subscription->get_id() ); ?>"
					<?php echo ! empty( $plan_id ) ? 'data-plan-id="' . esc_attr( $plan_id ) . '"' : ''; ?>
				></div>

				<div id="ms-gateway-paypalexpress-card-fields" style="display: none;">
					<p id="ms-gateway-paypalexpress-card-fields-title">
						<?php esc_html_e( 'Or pay with card:', 'memberdash' ); ?>
					</p>
					<div id="ms-gateway-paypalexpress-card-name-field"></div>
					<div id="ms-gateway-paypalexpress-card-number-field"></div>
					<div id="ms-gateway-paypalexpress-card-expiry-field"></div>
					<div id="ms-gateway-paypalexpress-card-cvv-field"></div>
					<p>
						<button id="ms-gateway-paypalexpress-card-submit" type="button">
							<?php esc_html_e( 'Pay Now', 'memberdash' ); ?>
						</button>
					</p>
				</div>

				<script
					class="ms-gateway-paypalexpress-script"
					src="<?php echo esc_url( $this->data['js_sdk_url'] ); ?>"
					data-page-type="checkout"
					data-partner-attribution-id="<?php echo esc_attr( $gateway->get_partner_attribution_id() ); ?>"
					<?php if ( ! empty( $this->data['client_token'] ) ) : ?>
						data-client-token="<?php echo esc_attr( $this->data['client_token'] ); ?>"
					<?php endif; ?>
					<?php if ( ! empty( $this->data['client_token_expires_in'] ) ) : ?>
						data-client-token-expires-in="<?php echo esc_attr( $this->data['client_token_expires_in'] ); ?>"
					<?php endif; ?>
				></script>

			</td>
		</tr>

		<?php
		return MS_Helper_Cast::to_string( ob_get_clean() );
	}
}


