<?php
/**
 * Gateway: Paypal Express - Notice View
 *
 * @since 1.5.0
 *
 * @package MemberDash
 */

/**
 * PayPal Express gateway notice view class.
 *
 * @since 1.5.0
 */
class MS_Gateway_Paypalexpress_View_Notice extends MS_View {
	/**
	 * Returns the HTML for the notice page.
	 *
	 * @since 1.5.0
	 *
	 * @return string
	 */
	public function to_html() {
		$notice      = $this->data['message'];
		$notice_type = $this->data['type'];

		ob_start();
		?>
		<div class="notice notice-<?php echo esc_attr( $notice_type ); ?> is-dismissible">
			<p><?php echo esc_html( $notice ); ?></p>
		</div>
		<?php
		return MS_Helper_Cast::to_string( ob_get_clean() );
	}
}
