<?php
/**
 * Membership Account
 *
 * @since 1.0.0
 *
 * @package MemberDash
 */

?>
<div class="ms-account-wrapper">
		<?php if ( ms_is_user_logged_in() ) : ?>
				<?php if ( ms_show_users_membership() ) : ?>
				<div id="account-membership">
					<div class="ms-account-header">
						<h2>
							<?php echo get_ms_ac_title(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						</h2>

						<?php
						if ( show_membership_change_link() ) {
							echo get_ms_ac_signup_modified_url(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						}
						?>
					</div>
					<?php
					/**
					 * Add custom content right before the memberships list.
					 *
					 * @since 1.0.0
					 */
					do_action( 'ms_view_account_memberships_top', get_ms_ac_member_obj(), get_ms_ac_account_obj() );

					if ( is_ms_admin_user() ) {
						esc_html_e( 'You are an admin user and have access to all memberships', 'memberdash' );
					} else {
						if ( has_ms_ac_subscriptions() ) {
							?>
							<table class="ms-responsive-table">
								<thead>
									<tr>
										<th class="ms-col-membership" scope="col">
											<?php esc_html_e( 'Membership name', 'memberdash' ); ?>
										</th>
										<th class="ms-col-status" scope="col">
											<?php esc_html_e( 'Status', 'memberdash' ); ?>
										</th>
										<th class="ms-col-expire-date" scope="col">
											<?php esc_html_e( 'Expire date', 'memberdash' ); ?>
										</th>
									</tr>
								</thead>
								<tbody>
									<?php
									$memberdash_empty         = true;
									$memberdash_subscriptions = get_ms_ac_subscriptions();
									foreach ( $memberdash_subscriptions as $memberdash_subscription ) :
										$memberdash_empty = false;
										ms_account_the_membership( $memberdash_subscription );
										?>
											<tr class="<?php echo get_ms_account_classes(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>">
												<td class="ms-col-membership" data-label="<?php esc_attr_e( 'Membership name', 'memberdash' ); ?>">
													<?php echo get_ms_account_membership_name(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
												</td>
												<td class="ms-col-status" data-label="<?php esc_attr_e( 'Status', 'memberdash' ); ?>">
													<?php echo get_ms_account_membership_status(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
												</td>
												<td class="ms-col-expire-date" data-label="<?php esc_attr_e( 'Expire date', 'memberdash' ); ?>">
													<?php echo get_ms_account_expire_date(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
												</td>
											</tr>
										<?php
									endforeach;

									if ( $memberdash_empty ) {
										echo get_ms_no_account_membership_status(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
									}
									?>
								</tbody>
							</table>
							<?php
						} else {
							esc_html_e( 'No memberships', 'memberdash' );
						}
					}
					/**
					 * Add custom content right after the memberships list.
					 *
					 * @since 1.0.0
					 */
					do_action( 'ms_view_account_memberships_bottom', get_ms_ac_member_obj(), get_ms_ac_account_obj() );
					?>
				</div>
				<?php endif; ?>
				<?php
				// ===================================================== PROFILE
				if ( is_ms_ac_show_profile() ) :
					?>
				<div id="account-profile">
					<div class="ms-account-header">
						<h2>
							<?php echo get_ms_ac_profile_title(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						</h2>

						<?php
						if ( is_ms_ac_show_profile_change() ) {
							echo get_ms_ac_profile_change_link(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						}
						?>
					</div>
					<?php
					/**
					 * Add custom content right before the profile overview.
					 *
					 * @since 1.0.0
					 */
					do_action( 'ms_view_account_profile_top', get_ms_ac_member_obj(), get_ms_ac_account_obj() );
					?>
				<table>
						<?php $memberdash_profile_fields = get_ms_ac_profile_fields(); ?>
						<?php foreach ( $memberdash_profile_fields as $memberdash_field => $memberdash_title ) : ?>
								<tr>
										<th class="ms-label-title"><?php echo esc_html( $memberdash_title ); ?>: </th>
										<td class="ms-label-field"><?php echo esc_html( get_ms_ac_profile_info( $memberdash_field ) ); ?></td>
								</tr>
						<?php endforeach; ?>
				</table>
					<?php
					do_action( 'ms_view_account_profile_before_card', get_ms_ac_member_obj(), get_ms_ac_account_obj() );


					do_action( 'ms_view_shortcode_account_card_info', get_ms_ac_data() );

					/**
					 * Add custom content right after the profile overview.
					 *
					 * @since 1.0.0
					 */
					do_action( 'ms_view_account_profile_bottom', get_ms_ac_member_obj(), get_ms_ac_account_obj() );
					?>
				</div>
					<?php
				endif;
				// END: if ( $show_profile )
				// =============================================================
				?>

				<?php
				// ==================================================== INVOICES
				if ( is_ms_ac_show_invoices() ) :
					?>
				<div id="account-invoices">
					<div class="ms-account-header">
						<h2>
							<?php echo get_ms_ac_invoices_title(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						</h2>

						<?php
						if ( is_ms_ac_show_all_invoices() ) {
							echo get_ms_ac_invoices_detail_label(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						}
						?>
					</div>
					<?php
					/**
					 * Add custom content right before the invoice overview list.
					 *
					 * @since 1.0.0
					 */
					do_action( 'ms_view_account_invoices_top', get_ms_ac_member_obj(), get_ms_ac_account_obj() );
					?>
				<table class="ms-responsive-table">
					<thead>
						<tr>
							<th class="ms-col-invoice-no" scope="col">
								<?php esc_html_e( 'Invoice #', 'memberdash' ); ?>
							</th>
							<th class="ms-col-invoice-status" scope="col">
								<?php esc_html_e( 'Status', 'memberdash' ); ?>
							</th>
							<th class="ms-col-invoice-total" scope="col">
								<?php
								printf(
									'%s (%s)',
									esc_html__( 'Total', 'memberdash' ),
									esc_attr( MS_Plugin::get_settings()->get_currency() )
								);
								?>
							</th>
							<th class="ms-col-invoice-title" scope="col">
								<?php esc_html_e( 'Membership', 'memberdash' ); ?>
							</th>
							<th class="ms-col-invoice-due" scope="col">
								<?php esc_html_e( 'Due date', 'memberdash' ); ?>
							</th>
						</tr>
					</thead>
					<tbody>
					<?php
					$memberdash_invoices = get_ms_ac_invoices();
					foreach ( $memberdash_invoices as $memberdash_invoice ) :
						ms_account_the_invoice( $memberdash_invoice );
						?>
						<tr class="<?php echo get_ms_invoice_classes(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>">
							<td class="ms-col-invoice-no" data-label="<?php esc_attr_e( 'Invoice #', 'memberdash' ); ?>">
								<?php echo get_ms_invoice_number(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</td>
							<td class="ms-col-invoice-status" data-label="<?php esc_attr_e( 'Status', 'memberdash' ); ?>">
								<?php echo get_ms_invoice_next_status(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</td>
							<td
								class="ms-col-invoice-total"
								data-label="
								<?php
								// translators: %s Currency code.
								echo esc_attr( sprintf( __( 'Total (%s)', 'memberdash' ), MS_Plugin::get_settings()->get_currency() ) );
								?>
								">
								<?php echo get_ms_invoice_total(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</td>
							<td class="ms-col-invoice-title" data-label="<?php esc_attr_e( 'Membership', 'memberdash' ); ?>">
								<?php echo get_ms_invoice_name(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</td>
							<td class="ms-col-invoice-due" data-label="<?php esc_attr_e( 'Due date', 'memberdash' ); ?>">
								<?php echo get_ms_invoice_due_date(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</td>
						</tr>
					<?php endforeach; ?>
					</tbody>
				</table>
					<?php
					/**
					 * Add custom content right after the invoices overview list.
					 *
					 * @since 1.0.0
					 */
					do_action( 'ms_view_account_invoices_bottom', get_ms_ac_member_obj(), get_ms_ac_account_obj() );
					?>
				</div>
					<?php
				endif;
				?>

				<?php
				// ==================================================== ACTIVITY
				if ( is_ms_ac_show_activity() ) :
					?>
				<div id="account-activity">
					<div class="ms-account-header">
						<h2>
							<?php echo get_ms_ac_activity_title(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						</h2>

						<?php
						if ( is_ms_ac_show_all_activities() ) {
							echo get_ms_ac_activity_details_label(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						}
						?>
					</div>
					<?php
					/**
					 * Add custom content right before the activities overview list.
					 *
					 * @since 1.0.0
					 */
					do_action( 'ms_view_account_activity_top', get_ms_ac_member_obj(), get_ms_ac_account_obj() );
					?>
				<table>
						<thead>
								<tr>
										<th class="ms-col-activity-date">
										<?php
												esc_html_e( 'Date', 'memberdash' );
										?>
										</th>
										<th class="ms-col-activity-title">
										<?php
												esc_html_e( 'Activity', 'memberdash' );
										?>
										</th>
								</tr>
						</thead>
						<tbody>
						<?php $mwps_events = get_ms_ac_events(); ?>
						<?php
						foreach ( $mwps_events as $event ) :
								ms_account_the_event( $event );
							?>
								<tr class="<?php echo get_ms_event_classes(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>">
										<td class="ms-col-activity-date"><?php echo get_ms_event_date(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>
										<td class="ms-col-activity-title"><?php echo get_ms_event_description(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>
								</tr>
						<?php endforeach; ?>
						</tbody>
				</table>
					<?php
					/**
					 * Add custom content right after the activities overview list.
					 *
					 * @since 1.0.0
					 */
					do_action( 'ms_view_account_activity_bottom', get_ms_ac_member_obj(), get_ms_ac_account_obj() );
					?>
				</div>
					<?php
				endif;
				?>

			<?php
		else :

			if ( ! has_ms_ac_login_form() ) {
					echo get_ms_ac_login_form(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}
		endif;
		?>
</div>
