<?php
/**
 * Code-snippet for WordPress plugin list.
 * Used in function mslib3()->html->addon_list()
 *
 * @since 1.0.0
 *
 * Variables:
 *   - $items
 *   - $lang
 *   - $filters
 */

$item_fields = array(
	'class',
	'title',
	'description',
	'version',
	'author',
	'active',
	'action', // Array
	'details', // Array
	'icon',
	'footer',
	'settings_link',
);
?>
<div class="memberdash-list-wrapper ms-flex ms-space-x-6">

	<?php if ( ! empty( $filters ) ) : ?>
		<div class="wp-filter ms-w-32 ms-m-0 ms-p-0 ms-bg-transparent ms-no-shadow ms-border-0 ms-shadow-none">
			<ul class="ms-flex ms-flex-col ms-m-0 ms-p-3 ms-list-none ms-space-y-1 ms-bg-gray-800 ms-rounded-lg">
				<?php $i = 0; ?>
				<?php foreach ( $filters as $key => $label ) : ?>
					<li class="ms-text-center">
						<a
							href="#"
							data-filter="<?php echo esc_attr( $key ); ?>"
							class="filter <?php echo esc_attr( $i === 0 ? 'current' : '' ); ?> ms-m-0 ms-float-none ms-text-gray-400 hover:ms-bg-gray-700 ms-group ms-w-full ms-p-3 ms-rounded-md ms-flex ms-flex-col ms-items-center ms-text-xs ms-font-medium ms-no-underline"
						>
							<svg class="ms-text-gray-400 ms-h-6 ms-w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
								<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
							</svg>
							<span class="ms-mt-2">
								<?php echo esc_html( $label ); ?>
							</span>
						</a>
					</li>
					<?php $i++; ?>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endif; ?>

	<div class="wp-list-table widefat memberdash-list-table ms-m-0">
		<div class="the-list memberdash-list ms-gap-5 ms-grid ms-grid-cols-1 xl:ms-grid-cols-2">
			<?php
			foreach ( $items as $item ) :
				// don't show add-ons enabled by default
				if ( $item->enabled_by_default ) {
					continue;
				}

				self::$core->array->equip( $item, $item_fields );
				if ( isset( $item->action ) && is_array( $item->action ) ) {
					$item->details = self::$core->array->get( $item->details );
				} else {
					$item->action  = array();
					$item->details = array();
				}

				$item_class  = $item->active ? 'active' : '';
				$item_class .= ' ' . $item->class;
				?>
				<div class="list-card ms-col-span-1 ms-bg-white ms-rounded-lg ms-shadow ms-divide-y ms-divide-gray-200 <?php echo esc_attr( $item_class ); ?>">
					<div class="list-card-top">
						<div class="name">
							<h4 class="
							<?php
							if ( $item->details ) :
								?>
								toggle-details<?php endif; ?> is-no-detail">
								<?php echo esc_html( $item->title ); ?>
							</h4>
							<h4 class="is-detail">
								<?php echo esc_html( $item->title ); ?>
							</h4>
						</div>

						<div class="desc">
							<?php echo $item->description; ?>
						</div>

						<div class="action-links">
							<span class="toggle-details toggle-link is-detail close-button"></span>
							<?php
							foreach ( $item->action as $action ) {
								self::$core->html->element( $action );
							}
							?>
						</div>

						<div class="details">
							<?php
							foreach ( $item->details as $detail ) {
								if ( is_array( $detail ) ) {
									if ( isset( $detail['ajax_data'] )
										 && is_array( $detail['ajax_data'] )
									) {
										$detail['ajax_data']['_is_detail'] = true;
									}
								}
								self::$core->html->element( $detail );
							}
							?>
						</div>
					</div>

					<div class="list-card-bottom">
						<?php if ( $item->footer ) : ?>
							<span class="list-card-footer is-no-detail">
								<?php echo $item->footer; ?>
							</span>
						<?php endif; ?>

						<?php if ( $item->settings_link ) : ?>
							<span class="toggle-link">
								<a href="<?php echo esc_url( $item->settings_link ); ?>">
								<?php echo esc_html( $lang->show_details ); ?>
								</a>
							</span>
						<?php elseif ( $item->details ) : ?>
							<span class="toggle-details toggle-link is-no-detail">
								<?php echo esc_html( $lang->show_details ); ?>
							</span>
							<span class="toggle-details toggle-link is-detail">
								<?php echo esc_html( $lang->close_details ); ?>
							</span>
						<?php endif; ?>

					</div>
				</div>
			<?php endforeach; ?>
		</div>
	</div>

</div>
