<?php

// File generated from our OpenAPI spec

namespace StellarWP\Memberdash\Stripe\Service\Treasury;

class InboundTransferService extends \StellarWP\Memberdash\Stripe\Service\AbstractService
{
    /**
     * Returns a list of InboundTransfers sent from the specified FinancialAccount.
     *
     * @param null|array $params
     * @param null|array|\StellarWP\Memberdash\Stripe\Util\RequestOptions $opts
     *
     * @throws \StellarWP\Memberdash\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \StellarWP\Memberdash\Stripe\Collection<\Stripe\Treasury\InboundTransfer>
     *
     * @license MIT
     * Modified by memberdash on 13-November-2025 using Strauss.
     * @see https://github.com/BrianHenryIE/strauss
     */
    public function all($params = null, $opts = null)
    {
        return $this->requestCollection('get', '/v1/treasury/inbound_transfers', $params, $opts);
    }

    /**
     * Cancels an InboundTransfer.
     *
     * @param string $id
     * @param null|array $params
     * @param null|array|\StellarWP\Memberdash\Stripe\Util\RequestOptions $opts
     *
     * @throws \StellarWP\Memberdash\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \StellarWP\Memberdash\Stripe\Treasury\InboundTransfer
     */
    public function cancel($id, $params = null, $opts = null)
    {
        return $this->request('post', $this->buildPath('/v1/treasury/inbound_transfers/%s/cancel', $id), $params, $opts);
    }

    /**
     * Creates an InboundTransfer.
     *
     * @param null|array $params
     * @param null|array|\StellarWP\Memberdash\Stripe\Util\RequestOptions $opts
     *
     * @throws \StellarWP\Memberdash\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \StellarWP\Memberdash\Stripe\Treasury\InboundTransfer
     */
    public function create($params = null, $opts = null)
    {
        return $this->request('post', '/v1/treasury/inbound_transfers', $params, $opts);
    }

    /**
     * Retrieves the details of an existing InboundTransfer.
     *
     * @param string $id
     * @param null|array $params
     * @param null|array|\StellarWP\Memberdash\Stripe\Util\RequestOptions $opts
     *
     * @throws \StellarWP\Memberdash\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \StellarWP\Memberdash\Stripe\Treasury\InboundTransfer
     */
    public function retrieve($id, $params = null, $opts = null)
    {
        return $this->request('get', $this->buildPath('/v1/treasury/inbound_transfers/%s', $id), $params, $opts);
    }
}
