<?php

// File generated from our OpenAPI spec

namespace StellarWP\Memberdash\Stripe;

/**
 * Client used to send requests to Stripe's API.
 *
 * @property \StellarWP\Memberdash\Stripe\Service\AccountLinkService $accountLinks
 * @property \StellarWP\Memberdash\Stripe\Service\AccountService $accounts
 * @property \StellarWP\Memberdash\Stripe\Service\ApplePayDomainService $applePayDomains
 * @property \StellarWP\Memberdash\Stripe\Service\ApplicationFeeService $applicationFees
 * @property \StellarWP\Memberdash\Stripe\Service\Apps\AppsServiceFactory $apps
 * @property \StellarWP\Memberdash\Stripe\Service\BalanceService $balance
 * @property \StellarWP\Memberdash\Stripe\Service\BalanceTransactionService $balanceTransactions
 * @property \StellarWP\Memberdash\Stripe\Service\BillingPortal\BillingPortalServiceFactory $billingPortal
 * @property \StellarWP\Memberdash\Stripe\Service\ChargeService $charges
 * @property \StellarWP\Memberdash\Stripe\Service\Checkout\CheckoutServiceFactory $checkout
 * @property \StellarWP\Memberdash\Stripe\Service\CountrySpecService $countrySpecs
 * @property \StellarWP\Memberdash\Stripe\Service\CouponService $coupons
 * @property \StellarWP\Memberdash\Stripe\Service\CreditNoteService $creditNotes
 * @property \StellarWP\Memberdash\Stripe\Service\CustomerService $customers
 * @property \StellarWP\Memberdash\Stripe\Service\DisputeService $disputes
 * @property \StellarWP\Memberdash\Stripe\Service\EphemeralKeyService $ephemeralKeys
 * @property \StellarWP\Memberdash\Stripe\Service\EventService $events
 * @property \StellarWP\Memberdash\Stripe\Service\ExchangeRateService $exchangeRates
 * @property \StellarWP\Memberdash\Stripe\Service\FileLinkService $fileLinks
 * @property \StellarWP\Memberdash\Stripe\Service\FileService $files
 * @property \StellarWP\Memberdash\Stripe\Service\FinancialConnections\FinancialConnectionsServiceFactory $financialConnections
 * @property \StellarWP\Memberdash\Stripe\Service\Identity\IdentityServiceFactory $identity
 * @property \StellarWP\Memberdash\Stripe\Service\InvoiceItemService $invoiceItems
 * @property \StellarWP\Memberdash\Stripe\Service\InvoiceService $invoices
 * @property \StellarWP\Memberdash\Stripe\Service\Issuing\IssuingServiceFactory $issuing
 * @property \StellarWP\Memberdash\Stripe\Service\MandateService $mandates
 * @property \StellarWP\Memberdash\Stripe\Service\OAuthService $oauth
 * @property \StellarWP\Memberdash\Stripe\Service\PaymentIntentService $paymentIntents
 * @property \StellarWP\Memberdash\Stripe\Service\PaymentLinkService $paymentLinks
 * @property \StellarWP\Memberdash\Stripe\Service\PaymentMethodService $paymentMethods
 * @property \StellarWP\Memberdash\Stripe\Service\PayoutService $payouts
 * @property \StellarWP\Memberdash\Stripe\Service\PlanService $plans
 * @property \StellarWP\Memberdash\Stripe\Service\PriceService $prices
 * @property \StellarWP\Memberdash\Stripe\Service\ProductService $products
 * @property \StellarWP\Memberdash\Stripe\Service\PromotionCodeService $promotionCodes
 * @property \StellarWP\Memberdash\Stripe\Service\QuoteService $quotes
 * @property \StellarWP\Memberdash\Stripe\Service\Radar\RadarServiceFactory $radar
 * @property \StellarWP\Memberdash\Stripe\Service\RefundService $refunds
 * @property \StellarWP\Memberdash\Stripe\Service\Reporting\ReportingServiceFactory $reporting
 * @property \StellarWP\Memberdash\Stripe\Service\ReviewService $reviews
 * @property \StellarWP\Memberdash\Stripe\Service\SetupAttemptService $setupAttempts
 * @property \StellarWP\Memberdash\Stripe\Service\SetupIntentService $setupIntents
 * @property \StellarWP\Memberdash\Stripe\Service\ShippingRateService $shippingRates
 * @property \StellarWP\Memberdash\Stripe\Service\Sigma\SigmaServiceFactory $sigma
 * @property \StellarWP\Memberdash\Stripe\Service\SourceService $sources
 * @property \StellarWP\Memberdash\Stripe\Service\SubscriptionItemService $subscriptionItems
 * @property \StellarWP\Memberdash\Stripe\Service\SubscriptionScheduleService $subscriptionSchedules
 * @property \StellarWP\Memberdash\Stripe\Service\SubscriptionService $subscriptions
 * @property \StellarWP\Memberdash\Stripe\Service\Tax\TaxServiceFactory $tax
 * @property \StellarWP\Memberdash\Stripe\Service\TaxCodeService $taxCodes
 * @property \StellarWP\Memberdash\Stripe\Service\TaxRateService $taxRates
 * @property \StellarWP\Memberdash\Stripe\Service\Terminal\TerminalServiceFactory $terminal
 * @property \StellarWP\Memberdash\Stripe\Service\TestHelpers\TestHelpersServiceFactory $testHelpers
 * @property \StellarWP\Memberdash\Stripe\Service\TokenService $tokens
 * @property \StellarWP\Memberdash\Stripe\Service\TopupService $topups
 * @property \StellarWP\Memberdash\Stripe\Service\TransferService $transfers
 * @property \StellarWP\Memberdash\Stripe\Service\Treasury\TreasuryServiceFactory $treasury
 * @property \StellarWP\Memberdash\Stripe\Service\WebhookEndpointService $webhookEndpoints
 *
 * @license MIT
 * Modified by memberdash on 13-November-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */
class StripeClient extends BaseStripeClient
{
    /**
     * @var \StellarWP\Memberdash\Stripe\Service\CoreServiceFactory
     */
    private $coreServiceFactory;

    public function __get($name)
    {
        return $this->getService($name);
    }

    public function getService($name)
    {
        if (null === $this->coreServiceFactory) {
            $this->coreServiceFactory = new \StellarWP\Memberdash\Stripe\Service\CoreServiceFactory($this);
        }

        return $this->coreServiceFactory->getService($name);
    }
}
