<?php
/**
 * Membership Attributes View Add-on.
 *
 * @since  1.0.0
 *
 * @package Memberdash
 */

/**
 * Membership Attributes View Add-on.
 *
 * @since  1.0.0
 */
class MS_Addon_Attributes_View_Membership extends MS_View {

	/**
	 * Outputs the HTML code of the Settings form.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function render_tab() {
		$fields = $this->prepare_fields();

		$manage_url = MS_Controller_Plugin::get_admin_url(
			'settings',
			array( 'tab' => MS_Addon_Attributes::ID )
		);

		ob_start();
		?>
		<div class="ms-addon-wrap">
			<?php
			MS_Helper_Html::settings_tab_header(
				array(
					'title' => __( 'Custom Membership Attributes', 'memberdash' ),
					'desc'  => sprintf(
					// translators: %1$s: opening link tag, %2$s: closing link tag.
						__( 'You can manage custom attributes in %1$sthe plugin settings%2$s.', 'memberdash' ), // cspell:disable-line.
						'<a href="' . $manage_url . '">',
						'</a>'
					),
				)
			);

			echo '<div class="ms-attributes">';
			foreach ( $fields as $field ) {
				MS_Helper_Html::html_element( $field );
			}
			echo '</div>';
			?>
		</div>
		<?php
		$html = ob_get_clean();
		echo $html; //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	/**
	 * Prepare fields that are displayed in the form.
	 *
	 * @since 1.0.0
	 * @return array
	 */
	protected function prepare_fields() {
		$membership = $this->data['membership'];
		$action     = MS_Addon_Attributes::AJAX_ACTION_SAVE_ATTRIBUTE;

		$fields    = array();
		$field_def = MS_Addon_Attributes::list_field_def();

		foreach ( $field_def as $field ) {
			$field_type = MS_Helper_Html::INPUT_TYPE_TEXT;
			$before     = '';
			$after      = '';
			$value      = MS_Addon_Attributes::get_attr(
				$field->slug,
				$membership
			);

			switch ( $field->type ) {
				case 'number':
					$field_type = MS_Helper_Html::INPUT_TYPE_NUMBER;
					break;

				case 'textarea':
					$field_type = MS_Helper_Html::INPUT_TYPE_TEXT_AREA;
					break;

				case 'bool':
					$field_type = MS_Helper_Html::INPUT_TYPE_RADIO_SLIDER;
					$before     = __( 'No', 'memberdash' );
					$after      = __( 'Yes', 'memberdash' );
			}

			$fields[] = array(
				'id'        => $field->slug,
				'title'     => $field->title,
				'desc'      => $field->info,
				'type'      => $field_type,
				'value'     => $value,
				'before'    => $before,
				'after'     => $after,
				'ajax_data' => array(
					'action'        => $action,
					'_wpnonce'      => wp_create_nonce( $action ),
					'field'         => $field->slug,
					'membership_id' => $membership->id,
				),
			);
		}

		return $fields;
	}
}
