/**
 * PayPal Express - Admin scripts.
 *
 * @since 1.5.0
 */
/*global memberdashLi:false */
/*global msPayPalExpressAdmin:false */

jQuery(function ($) {
	/**
	 * Update the connect URL.
	 *
	 * @param {jQuery} el The country select element.
	 *
	 * @return {void}
	 */
	function update_connect_url(el) {
		const country = $(el).val(),
			button = $('.gateway-paypalexpress #connect_button');

		// Disable the button and show the loading spinner.
		button.addClass('disabled').addClass('memberdash-loading');

		$.ajax({
			url: window.ajaxurl,
			data: {
				action: msPayPalExpressAdmin.refresh_connect_url.action,
				account_country: country,
				nonce: msPayPalExpressAdmin.refresh_connect_url.nonce,
			},
			type: 'GET',
			dataType: 'json',
		}).done(function (response) {
			if (response.success) {
				// Update the connect URL.
				button
					.attr('href', response.data.connect_url)
					.removeClass('memberdash-loading')
					.removeClass('disabled');
			}
		});
	}

	$('.gateway-paypalexpress #connect_button').on('click', function (evt) {
		const href = $(this).attr('href');

		// Prevent the link from being followed if it's empty.
		if (!href) {
			evt.preventDefault();
		}
	});

	$('.gateway-paypalexpress.not-configured #account_country').on(
		'change',
		function () {
			update_connect_url(this);
		}
	);

	// Update the connect URL when the "not-configured" box is opened.
	$('.gateway-paypalexpress.not-configured .gateway-toggle').on(
		'click',
		function () {
			const open = $(this)
				.closest('.gateway-paypalexpress')
				.hasClass('open');

			// Only update the connect URL if the box is open before the click.
			if (open) {
				return;
			}

			update_connect_url($('.gateway-paypalexpress #account_country'));
		}
	);

	$('.gateway-paypalexpress #disconnect_button').on('click', function (evt) {
		evt.preventDefault();

		const self = $(this);

		self.addClass('memberdash-loading');

		memberdashLi.confirm({
			message: msPayPalExpressAdmin.actions.disconnect.message,
			buttons: [
				msPayPalExpressAdmin.actions.disconnect.btn_disconnect,
				msPayPalExpressAdmin.actions.disconnect.btn_cancel,
			],
			callback(key) {
				if (key !== 0) {
					self.removeClass('memberdash-loading');
					return;
				}

				$.ajax({
					url: window.ajaxurl,
					data: {
						action: msPayPalExpressAdmin.actions.disconnect.action,
						nonce: msPayPalExpressAdmin.actions.disconnect.nonce,
					},
					type: 'POST',
					dataType: 'json',
				}).done(function (response) {
					if (response.success) {
						window.location = response.data.url;
					}
				});
			},
		});
	});

	$('.gateway-paypalexpress #reconnect_button').on('click', function (evt) {
		evt.preventDefault();

		$(this).addClass('memberdash-loading');

		$.ajax({
			url: window.ajaxurl,
			data: {
				action: msPayPalExpressAdmin.actions.reconnect.action,
				nonce: msPayPalExpressAdmin.actions.reconnect.nonce,
			},
			type: 'POST',
			dataType: 'json',
		}).done(function (response) {
			if (response.success) {
				window.location = response.data.url;
			}
		});
	});

	if (location.search.indexOf('paypal-express-notice=connected') !== -1) {
		const dialog_el = $('.ms-paypal-express-gateway-connected');
		if (!dialog_el.length) {
			return;
		}

		memberdashLi
			.popup()
			.modal(true)
			.title(msPayPalExpressAdmin.actions.connected.title)
			.size(800, 550)
			.content(dialog_el.html())
			.show();
	}
});

/**
 * PayPal Express - Onboarding complete callback.
 *
 * @since 1.5.0
 *
 * @param {string} authCode The authorization code.
 * @param {string} sharedId The shared ID.
 *
 * @return {void}
 */
window.msGatewayPayPalExpressSignupCallback = function (authCode, sharedId) {
	jQuery.ajax({
		url: window.ajaxurl,
		data: {
			action: msPayPalExpressAdmin.onboarding_complete.action,
			auth_code: authCode,
			shared_id: sharedId,
			nonce: msPayPalExpressAdmin.onboarding_complete.nonce,
		},
		type: 'POST',
		dataType: 'json',
	});
};
