/*global msStripeAccount:false */

jQuery(function ($) {
	/**
	 * Redirect to Stripe customer portal.
	 *
	 * @since 1.2.0
	 *
	 * @param {Object} evt Event object.
	 *
	 * @return {void}
	 */
	$('#stripe-customer-portal').on('click', function (evt) {
		evt.preventDefault();

		const data = {
			action: msStripeAccount.action_customer_portal,
			_wpnonce: msStripeAccount.nonce,
		};

		// Clean error messages.
		const errorWrap = $('#error-message');
		errorWrap.empty();

		// Add loading message.
		const loading = $('<p />')
			.addClass('ms-loading-message')
			.text(msStripeAccount.loading_text);

		$('#account-stripe-payment-details').append(loading);

		// Fetch Stripe customer portal URL.
		$.get(msApp.ajax_url, data, function (response) {
			if (response.success) {
				// Redirect to customer portal with response.data.url.
				window.location.href = response.data.url;
			} else {
				// Remove loading message.
				loading.remove();

				// Create error message.
				const error = $('<p />')
					.addClass('ms-alert-box ms-alert-error')
					.text(response.data.message);

				// Display error message.
				errorWrap.append(error);
			}
		});
	});
});
