<?php
/**
 * Stripe Plan Button View.
 *
 * @since 1.0.0
 *
 * @package MemberDash
 */

/**
 * Stripe Plan Button View Class.
 *
 * @since 1.0.0
 */
class MS_Gateway_Stripeplan_View_Button extends MS_View {
	/**
	 * Returns the HTML for the button.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function to_html() {
		$gateway = $this->data['gateway'];

		/**
		 * Filters the button HTML.
		 *
		 * Empty by default to not duplicate in the frontend with the other stripe gateway.
		 *
		 * @since 1.0.0
		 *
		 * @param string                            $html    The button HTML. Default empty.
		 * @param MS_Gateway_Stripeplan_View_Button $gateway The button view.
		 *
		 * @return string
		 */
		$html = apply_filters(
			'ms_gateway_button-' . $gateway->id,
			'',
			$this
		);

		return $html;
	}
}
