<?php
/**
 * Communication model - user sign up.
 * Triggered when a new user creates an WordPress account.
 *
 * Persisted by parent class MS_Model_CustomPostType.
 *
 * @since 1.0.0
 * @package MemberDash
 * @subpackage Model
 */
class MS_Model_Communication_Signup extends MS_Model_Communication {

	/**
	 * Communication type.
	 *
	 * @since 1.0.0
	 * @var string The communication type.
	 */
	protected $type = self::COMM_TYPE_SIGNUP;

	/**
	 * Get communication description.
	 *
	 * @since 1.0.0
	 * @return string The description.
	 */
	public function get_description() {
		return __(
			'Welcome email sent after a new user account is created.',
			'memberdash'
		);
	}

	/**
	 * Communication default communication.
	 *
	 * @since 1.0.0
	 */
	public function reset_to_default() {
		parent::reset_to_default();

		$this->subject = sprintf(
			__( 'Welcome to %s!', 'memberdash' ),
			self::COMM_VAR_BLOG_NAME
		);
		$this->message = self::get_default_message();
		$this->enabled = false;

		do_action(
			'ms_model_communication_reset_to_default_after',
			$this->type,
			$this
		);
	}

	/**
	 * Get default email message.
	 *
	 * @since 1.0.0
	 * @return string The email message.
	 */
	public static function get_default_message() {
		$subject      = sprintf(
			__( 'Hi %1$s,', 'memberdash' ),
			self::COMM_VAR_USERNAME
		);
		$body_notice  = sprintf(
			__( 'welcome to %1$s! We have created a brand new account for you and you can head right over to %2$s and log in with your username and password.', 'memberdash' ),
			self::COMM_VAR_BLOG_NAME,
			self::COMM_VAR_BLOG_URL
		);
		$body_account = sprintf(
			__( 'Username: %1$s<br>Password: %2$s', 'memberdash' ),
			self::COMM_VAR_USERNAME,
			self::COMM_VAR_PASSWORD
		);

		$html = sprintf(
			'<h2>%1$s</h2><br /><br />%2$s<br /><br />%3$s',
			$subject,
			$body_notice,
			$body_account
		);

		return apply_filters(
			'ms_model_communication_signup_get_default_message',
			$html
		);
	}

	/**
	 * Process communication registration.
	 *
	 * @since 1.0.0
	 */
	public function process_communication( $event, $subscription ) {
		do_action(
			'ms_model_communication_signup_process_before',
			$subscription,
			$event,
			$this
		);

		$this->send_message( $subscription );

		do_action(
			'ms_model_communication_signup_process_after',
			$subscription,
			$event,
			$this
		);
	}
}
