<?php
/**
 * Activities Frontend view.
 *
 * @since 1.0.0
 *
 * @package MemberDash
 */

/**
 * Activities Frontend view.
 *
 * @since 1.0.0
 */
class MS_View_Frontend_Activities extends MS_View {

	/**
	 * Returns the HTML code.
	 *
	 * @since 1.0.0
	 *
	 * @return string HTML code.
	 */
	public function to_html() {
		ob_start();
		?>
		<div class="ms-account-wrapper ms-account-details-page">
			<?php if ( MS_Model_Member::is_logged_in() ) : ?>
				<h2>
					<?php esc_html_e( 'Activity', 'memberdash' ); ?>
				</h2>
				<table class="ms-responsive-table">
					<thead>
						<tr>
							<th class="ms-col-activity-date" scope="col">
							<?php esc_html_e( 'Date', 'memberdash' ); ?>
							</th>
							<th class="ms-col-activity-title" scope="col">
								<?php esc_html_e( 'Activity', 'memberdash' ); ?>
							</th>
						</tr>
					</thead>
					<tbody>
					<?php
					foreach ( $this->data['events'] as $event ) :
						$ev_classes = array(
							'ms-activity-topic-' . $event->topic,
							'ms-activity-type-' . $event->type,
							'ms-membership-' . $event->membership_id,
						);
						?>
						<tr class="<?php echo esc_attr( implode( ' ', $ev_classes ) ); ?>">
							<td class="ms-col-activity-date" data-label="<?php esc_attr_e( 'Date', 'memberdash' ); ?>">
								<?php
								echo esc_html(
									MS_Helper_Period::format_date(
										$event->post_modified,
										__( 'F j (H:i)', 'memberdash' )
									)
								);
								?>
							</td>
							<td class="ms-col-activity-title" data-label="<?php esc_attr_e( 'Activity', 'memberdash' ); ?>">
								<?php echo esc_html( $event->description ); ?>
							</td>
						</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
				<?php
			else :
				$redirect = esc_url_raw( add_query_arg( array() ) );
				$title    = __( 'Your account', 'memberdash' );
				echo do_shortcode( "[ms-membership-login redirect='$redirect' title='$title']" );
			endif;
			?>
		</div>
		<?php
		$html = ob_get_clean();
		$html = apply_filters( 'ms_compact_code', $html );

		return $html;
	}

}
