<?php

class MS_View_Membership_Overview_Dripped extends MS_View_Membership_Overview_Simple {

	public function available_content_panel_data() {
		$relative   = array();
		$absolute   = array();
		$membership = $this->data['membership'];
		$rule_types = MS_Model_Rule::get_dripped_rule_types();

		foreach ( $rule_types as $rule_type ) {
			$rule     = $membership->get_rule( $rule_type );
			$contents = (array) $rule->get_contents();

			foreach ( $contents as $content ) {
				if ( $rule->has_dripped_rules( $content->id ) ) {
					$infos         = $rule->dripped[ $content->id ];
					$key           = false;
					$content->date = $rule->get_dripped_description( $content->id );
					$content->icon = 'visibility';

					switch ( $infos['type'] ) {
						case MS_Model_Rule::DRIPPED_TYPE_FROM_REGISTRATION:
							$content->icon = 'clock';
							$key           = MS_Helper_Period::get_period_in_days(
								$infos['delay_unit'],
								$infos['delay_type']
							);
							$key           = 100000 + ( $key * 1000 );
							while ( isset( $relative[ $key ] ) ) {
								$key++; }
							$relative[ $key ] = $content;
							break;

						case MS_Model_Rule::DRIPPED_TYPE_SPEC_DATE:
							$key = preg_replace( '/[^0-9]/', '', $infos['date'] );
							if ( ! $rule->has_access( $content->id ) ) {
								$content->icon = 'lock';
							}
							// Fall through

						case MS_Model_Rule::DRIPPED_TYPE_INSTANTLY:
						default:
							if ( empty( $key ) ) {
								$key = 0; }

							$key = ( $key * 1000 );
							while ( isset( $relative[ $key ] ) ) {
								$key++; }
							$absolute[ $key ] = $content;
							break;
					}
				}
			}
			?>
			<div class="clear"></div>
			<div class="cf">
				<div class="ms-half ms-available-soon space">
					<div class="ms-bold">
						<i class="dashicons dashicons-calendar ms-low"></i>
						<?php esc_html_e( 'Available on a specific date:', 'memberdash' ); ?>
					</div>
					<div class="inside">
						<?php $this->content_box( $absolute, $rule ); ?>
					</div>
				</div>

				<div class="ms-half ms-available">
					<div class="ms-bold">
						<i class="dashicons dashicons-clock ms-low"></i>
						<?php esc_html_e( 'Relative to registration:', 'memberdash' ); ?>
					</div>
					<div class="inside">
						<?php $this->content_box( $relative, $rule ); ?>
					</div>
				</div>
			</div>

			<div class="cf">
				<div class="ms-half">
					<div class="inside">
						<div class="ms-protection-edit-wrapper">
							<?php
							$edit_url = MS_Controller_Plugin::get_admin_url(
								'protection',
								array(
									'tab'           => $rule->rule_type,
									'membership_id' => $membership->id,
								)
							);
							MS_Helper_Html::html_element(
								array(
									'id'    => 'edit_dripped',
									'type'  => MS_Helper_Html::TYPE_HTML_LINK,
									'value' => __( 'Edit Dripped Content', 'memberdash' ),
									'url'   => $edit_url,
									'class' => 'memberdash-field-button button',
								)
							);

							if ( ! $membership->is_free ) {
								$payment_url = esc_url_raw(
									add_query_arg(
										array(
											'step' => MS_Controller_Membership::STEP_PAYMENT,
											'edit' => 1,
										)
									)
								);
								MS_Helper_Html::html_element(
									array(
										'id'    => 'setup_payment',
										'type'  => MS_Helper_Html::TYPE_HTML_LINK,
										'value' => __( 'Payment Options', 'memberdash' ),
										'url'   => $payment_url,
										'class' => 'memberdash-field-button button',
									)
								);
							}
							?>
						</div>
					</div>
				</div>
			</div>

			<?php
		}
	}

	/**
	 * Echo a content list as 2-column table that show Content-Title and the
	 * Available date.
	 * Used by Dripped-Content view.
	 *
	 * @since 1.0.0
	 *
	 * @param  array $contents List of content items to display.
	 */
	protected function content_box( $contents, $rule ) {
		$row_class = '';
		ksort( $contents );
		$rule_titles = MS_Model_Rule::get_rule_type_titles();

		$edit_link = array(
			'id'   => 'edit_dripped',
			'type' => MS_Helper_Html::TYPE_HTML_LINK,
		);

		?>
		<table class="ms-list-table ms-list-date widefat">
			<thead>
				<tr>
					<th class="col-icon">&nbsp;</th>
					<th class="col-text"><?php esc_html_e( 'Rule', 'memberdash' ); ?></th>
					<th class="col-text"><?php esc_html_e( 'Protected Item', 'memberdash' ); ?></th>
					<th class="col-date"><?php esc_html_e( 'Access', 'memberdash' ); ?></th>
				</tr>
			</thead>
			<tbody>
			<?php
			foreach ( $contents as $id => $content ) :
				$row_class = ( $row_class == 'alternate' ? '' : 'alternate' );
				$edit_url  = MS_Controller_Plugin::get_admin_url(
					'protection',
					array(
						'tab' => $rule->rule_type,
					)
				);
				?>
				<tr class="<?php echo esc_attr( $row_class . ' ' . $content->icon ); ?>">
					<td class="col-icon">
						<i class="dashicons dashicons-<?php echo esc_attr( $content->icon ); ?>"></i>
					</td>
					<td class="col-text col-type">
						<?php
						$edit_link['url']   = esc_url_raw(
							add_query_arg(
								'tab',
								$content->type,
								$edit_url
							)
						);
						$edit_link['value'] = $rule_titles[ $content->type ];
						MS_Helper_Html::html_element( $edit_link );
						?>
					</td>
					<td class="col-text">
						<?php MS_Helper_Html::content_tag( $content, 'span' ); ?>
					</td>
					<td class="col-date">
						<?php echo esc_html( $content->date ); ?>
					</td>
				</tr>
			<?php endforeach; ?>
			</tbody>
		</table>
		<?php
	}
}
