<?php
/**
 * Settings > Backups.
 *
 * @since 1.3.1
 *
 * @package MemberDash
 */

/**
 * Settings > Backups page class.
 *
 * @since 1.3.1
 */
class MS_View_Settings_Page_Backups extends MS_View_Settings_Edit {

	/**
	 * Return the HTML form.
	 *
	 * @since 1.3.1
	 *
	 * @return string
	 */
	public function to_html() {
		$backups_enabled = is_plugin_active( 'backupbuddy/backupbuddy.php' );
		$images_dir      = MS_Plugin::instance()->get_url() . 'app/assets/images/settings/advanced/backups/';
		$purchase_url    = 'https://solidwp.com/memberdash-backups';
		$review_url      = admin_url( 'admin.php?page=pb_backupbuddy_settings' );

		ob_start();

		MS_Helper_Html::settings_tab_header(
			array(
				'title' => __( 'Backups', 'memberdash' ),
			)
		);

		MS_Helper_Html::settings_box_header();

		if ( $backups_enabled ) :
			?>

			<div class="ms-settings-backups ms-solid-enabled ms-flex ms-space-x-10">
				<div class="ms-settings-backups-content ms-w-3/5">
					<h1>
						<?php esc_html_e( 'Maximize Your Solid Backups Experience', 'memberdash' ); ?>
					</h1>

					<p>
						<?php esc_html_e( 'Congratulations on your purchase of Solid Backups &#x1F389; You&rsquo;ve taken the first step to protect your website from the worst-case scenario. All that&rsquo;s left to do is to review your backup settings.', 'memberdash' ); ?>
					</p>

					<p>
						<a
							class="button"
							href="<?php echo esc_url( $review_url ); ?>"
						>
							<?php esc_html_e( 'Review Backup Settings', 'memberdash' ); ?>
						</a>
					</p>
				</div>

				<div class="ms-settings-backups-thumbnail ms-w-2/5">
					<p>
						<img
							src="<?php echo esc_url( $images_dir . 'backups-in-app-confirmation.png' ); ?>"
							alt="<?php esc_attr_e( 'Backup', 'memberdash' ); ?>"
						>
					</p>
				</div>
			</div>

		<?php else : ?>

			<div class="ms-settings-backups ms-solid-disabled ms-flex">
				<div class="ms-settings-backups-content ms-w-3/5">
					<h1>
						<?php esc_html_e( 'Protect Your Membership Site From the Worst-Case Scenario', 'memberdash' ); ?>
					</h1>

					<p>
						<?php esc_html_e( 'With Solid Backups, your hard work and valuable data remain secure, allowing you to quickly recover and get back on track in case of any unfortunate events.', 'memberdash' ); ?>
					</p>

					<ul>
						<li><?php esc_html_e( 'Don&rsquo;t lose all your hard work', 'memberdash' ); ?></li>
						<li><?php esc_html_e( 'Your backup plan is a click away', 'memberdash' ); ?></li>
						<li><?php esc_html_e( 'Keep your website visitors and Google happy', 'memberdash' ); ?></li>
					</ul>

					<p>
						<a
							class="button"
							href="<?php echo esc_url( $purchase_url ); ?>"
						>
							<?php esc_html_e( 'Get Solid Backups', 'memberdash' ); ?>
						</a>
					</p>
				</div>

				<div class="ms-settings-backups-thumbnail ms-w-2/5">
					<p>
						<img
							src="<?php echo esc_url( $images_dir . 'backups-in-app.png' ); ?>"
							alt="<?php esc_attr_e( 'Backup', 'memberdash' ); ?>"
						>
					</p>
				</div>
			</div>

			<?php
		endif;

		$content = ob_get_clean();

		// If no content, return empty string.
		if ( ! $content ) {
			return '';
		}

		return $content;
	}
}
