<?php
/**
 * WooCommerce Product Variation Options View.
 *
 * @since 1.4.0
 *
 * @package MemberDash
 */

/**
 * WooCommerce Product Variation Options View class.
 *
 * @since 1.4.0
 */
class MS_View_WooCommerce_Product_Variation_Options extends MS_View_WooCommerce_Product_Options {
	/**
	 * Renders the product options.
	 *
	 * @since 1.4.0
	 *
	 * @return string
	 */
	public function to_html(): string {
		$memberships = $this->get_current_memberships();

		ob_start();
		?>

		<div class="options ms-product-variation-options">
			<h4><?php esc_html_e( 'MemberDash', 'memberdash' ); ?></h4>

			<?php
			$attributes = [
				'data-sortable'    => 'true',
				'data-placeholder' => __( 'Search for a membership&hellip;', 'memberdash' ),
				'data-action'      => 'memberdash_woocommerce_json_search_memberships',
			];

			if ( MS_Model_Addon::is_enabled( 'multi_memberships' ) ) {
				$attributes['multiple'] = 'multiple';
			}

			woocommerce_wp_select(
				[
					'id'                => sprintf(
						'ms_variable_memberships%d',
						$this->data['index']
					),
					'label'             => __( 'Membership', 'memberdash' ),
					'name'              => sprintf(
						'ms_variable_memberships[%d][]',
						$this->data['index']
					),
					'value'             => array_keys( $memberships ),
					'options'           => $memberships,
					'class'             => 'ms-membership-search wc-product-search',
					'wrapper_class'     => 'form-row form-row-full',
					'style'             => 'width: 100%;',
					'custom_attributes' => $attributes,
				]
			);
			?>
		</div>

		<?php
		return MS_Helper_Cast::to_string( ob_get_clean() );
	}
}
