<?php

// File generated from our OpenAPI spec

namespace StellarWP\Memberdash\Stripe\Service\Tax;

/**
 * Service factory class for API resources in the Tax namespace.
 *
 * @property CalculationService $calculations
 * @property SettingsService $settings
 * @property TransactionService $transactions
 *
 * @license MIT
 * Modified by memberdash on 13-November-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */
class TaxServiceFactory extends \StellarWP\Memberdash\Stripe\Service\AbstractServiceFactory
{
    /**
     * @var array<string, string>
     */
    private static $classMap = [
        'calculations' => CalculationService::class,
        'settings' => SettingsService::class,
        'transactions' => TransactionService::class,
    ];

    protected function getServiceClass($name)
    {
        return \array_key_exists($name, self::$classMap) ? self::$classMap[$name] : null;
    }
}
