<?php

// File generated from our OpenAPI spec

namespace StellarWP\Memberdash\Stripe\Service\Treasury;

class TransactionService extends \StellarWP\Memberdash\Stripe\Service\AbstractService
{
    /**
     * Retrieves a list of Transaction objects.
     *
     * @param null|array $params
     * @param null|array|\StellarWP\Memberdash\Stripe\Util\RequestOptions $opts
     *
     * @throws \StellarWP\Memberdash\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \StellarWP\Memberdash\Stripe\Collection<\Stripe\Treasury\Transaction>
     *
     * @license MIT
     * Modified by memberdash on 13-November-2025 using Strauss.
     * @see https://github.com/BrianHenryIE/strauss
     */
    public function all($params = null, $opts = null)
    {
        return $this->requestCollection('get', '/v1/treasury/transactions', $params, $opts);
    }

    /**
     * Retrieves the details of an existing Transaction.
     *
     * @param string $id
     * @param null|array $params
     * @param null|array|\StellarWP\Memberdash\Stripe\Util\RequestOptions $opts
     *
     * @throws \StellarWP\Memberdash\Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \StellarWP\Memberdash\Stripe\Treasury\Transaction
     */
    public function retrieve($id, $params = null, $opts = null)
    {
        return $this->request('get', $this->buildPath('/v1/treasury/transactions/%s', $id), $params, $opts);
    }
}
