<?php

namespace MEC_Advanced_Speaker\Core\Elementor\Widgets;

use Elementor\Controls_Manager;
use MEC_Advanced_Speaker\Core\SpeakerWidget\MEC_Advanced_Speaker_SpeakerWidget_Frontend;

class SpeakersFeatured extends \Elementor\Widget_Base {

	public function get_name() {

		return 'mec_advanced_speakers_Featured';
	}

	public function get_title() {

		return __( 'Featured Speakers', 'mec-advanced-speaker' );
	}

	public function get_icon() {

		return 'eicon-call-to-action';
	}

	public function get_categories() {

		return [ 'mec_advanced_speaker' ];
	}

	public function get_style_depends() {

		return [ 'mec-advanced-speaker-style' ];
	}

	public function get_script_depends() {

		return [ 'mec-advanced-speaker-frontend-script' ];
	}

	protected function register_controls() {

        $this->start_controls_section(
            'mec_advanced_speakers_list_settings',
            array(
                'label' 	=> __( 'Settings', 'mec-advanced-speaker' ),
                'tab'   	=> Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
			'limit',
			array(
				'label' 		=> __('Limit', 'mec-advanced-speaker'),
				'type' 			=> Controls_Manager::NUMBER,
                'default'       => 3,
            )
		);

        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $atts = array(
            'limit' => $settings['limit'] ?? 0,
        );

        echo MEC_Advanced_Speaker_SpeakerWidget_Frontend::speaker_featured_content( $atts, false );
	}

}