<?php

/**
 * Plugin Name: 	Elementor FES Builder for MEC
 * Plugin URI: http://webnus.net/modern-events-calendar/
 * Description: Use this Add-on to build your FES form in Elementor Editor. It allows you to use many different type of fields and rearrange them by drag and drop and modify their styles.
 * Author: Webnus
 * Version: 1.2.1
 * Elementor tested up to: 3.26.1
 * Elementor Pro tested up to: 3.26.1
 * Text Domain: mec-fes-builder
 * Domain Path: /languages
 * Author URI: http://webnus.net
 */

use MEC_FES_Builder\CheckPlugins;

// don't load directly.
if (!defined('ABSPATH')) {
	header('Status: 403 Forbidden');
	header('HTTP/1.1 403 Forbidden');
	exit;
}

if (!defined('MEC_FES_BUILDER_FILE')) {
	define('MEC_FES_BUILDER_FILE', __FILE__);
}

define('MECFBVERSION', '1.2.1');
define('MECFBDIR', plugin_dir_path(__FILE__));
define('MECFBURL', plugin_dir_url(__FILE__));
define('MECFBDASSETS', MECFBURL . '/assets/');
define('MECFBNAME', 'Elementor FES Builder');
define('MECFBSLUG', 'mec-fes-builder');
define('MECFBOPTIONS', 'MEC_FES_BUILDER_integration_options');
define('MECFBTEXTDOMAIN', 'mec-fes-builder');
define('MECFBMAINFILEPATH', __FILE__);
define('MECFBABSPATH', dirname(__FILE__));

if (!function_exists('mec_fes_builder_init')) {

	function mec_fes_builder_init()
	{

		\MEC_FES_Builder\Base::instance()->init();
		add_action('admin_init', 'mec_fes_builder_license');
	}
}

if (!function_exists('mec_fes_builder_license')) {

	function mec_fes_builder_license()
	{ //TODO: Develop
		require_once plugin_dir_path(__FILE__) . 'src/checkLicense/update-activation.php';
		new \MEC_FES_Builder\FESBUILDERAddonUpdateActivation();
	}
}

/**
 * Include Primary Class Plugin
 */
require plugin_dir_path(__FILE__) . 'vendor/autoload.php';

add_action('mec_init', 'mec_fes_builder_init');
add_action('admin_init', array(CheckPlugins::class, 'check_plugins'));
