<?php
/**
 * Class MEC_FES_Builder Admin Core
 *
 * @since           1.0.0
 */

namespace MEC_FES_Builder;

use MEC\Singleton;

/**
 * @since 1.0.0
 */
class Admin extends Singleton{

    /**
     * Init
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function init(){

        add_action( 'admin_menu', array( $this, 'add_menu' ) );
        add_action('parent_file', array( $this, 'mec_parent_menu_highlight' ) );
        add_action('submenu_file', array( $this, 'mec_sub_menu_highlight' ) );

        add_action( 'mec_settings_fes_form', array( __CLASS__, 'settings_fields' ) );
    }

    /**
     * Add admin menu
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function add_menu(){

        add_submenu_page(
			'mec-intro',
			__( 'FES Builder', MECFBTEXTDOMAIN ),
			__( 'FES Builder', MECFBTEXTDOMAIN ),
			'edit_posts',
			'edit.php?post_type=mec-fes-builder'
		);
    }


    /**
     * Return submenu highlight
     *
     * @param string $submenu_file
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function mec_sub_menu_highlight($submenu_file){

        global $current_screen;

        $post_type = $current_screen->post_type;

        switch($post_type){
            case 'mec-fes-builder':

                $submenu_file = 'edit.php?post_type=mec-fes-builder';
                break;
        }

        return $submenu_file;
    }

    /**
     * Return parent submenu highlight
     *
     * @param string $parent_file
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function mec_parent_menu_highlight($parent_file){

        global $current_screen;

        $post_type = $current_screen->post_type;

        switch($post_type){
            case 'mec-fes-builder':

                $parent_file = 'mec-intro';
                break;

            default:
                //nothing
                break;
        }

        return $parent_file;
    }

    public static function settings_fields( $settings ){

        $templates = get_posts(array(
            'post_type' => 'mec-fes-builder',
            'posts_per_page' => -1,
        ));
        ?>
        <div class="mec-form-row">
            <label class="mec-col-3" for="mec_settings_fes_template_id"><?php esc_html_e('Template', MECFBTEXTDOMAIN); ?></label>
            <div class="mec-col-9">
                <select id="mec_settings_fes_template_id" name="mec[settings][fes_template_id]">
                    <option <?php echo ((isset($settings['fes_template_id']) and $settings['fes_template_id'] == '0') ? 'selected="selected"' : ''); ?> value="0"><?php esc_html_e('Default', MECFBTEXTDOMAIN); ?></option>
                    <?php foreach( $templates as $template ): ?>
                        <option <?php echo ((isset($settings['fes_template_id']) and $settings['fes_template_id'] == $template->ID) ? 'selected="selected"' : ''); ?> value="<?php echo esc_attr( $template->ID ); ?>"><?php echo esc_html( $template->post_title ); ?></option>
                    <?php endforeach; ?>
                </select>
                <span class="mec-tooltip">
                    <div class="box left">
                        <h5 class="title"><?php esc_html_e('Frontend Event Submission Template', MECFBTEXTDOMAIN); ?></h5>
                        <div class="content"><p><?php esc_attr_e("Choose Template for the Frontend Event Submission.", MECFBTEXTDOMAIN); ?></p></div>
                    </div>
                    <i title="" class="dashicons-before dashicons-editor-help"></i>
                </span>
            </div>
        </div>
        <?php
    }
}
