<?php

namespace MEC_FES_Builder;

/**
 * @since 1.0.0
 */
class CheckPlugins {

    /**
     * Init
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function init(){

        self::check_plugins();
    }

    /**
     * Check MEC is active
     *
     * @since 1.0.0
     *
     * @return bool
     */
    public static function check_plugins() {

        if ( ! function_exists( 'is_plugin_active' ) ) {

            include_once ABSPATH . 'wp-admin/includes/plugin.php';
        }

        // if( !is_plugin_active( 'modern-events-calendar/mec.php' ) ){

        //     if ( self::is_mec_installed() == 'pro' && ! is_plugin_active( 'modern-events-calendar/mec.php' ) ) {

        //         add_action( 'admin_notices', [ __CLASS__, 'send_mec_notice' ] );

        //         return false;
        //     }
        // }

        if ( ! is_plugin_active( 'elementor/elementor.php' ) ) {

            add_action( 'admin_notices', [ __CLASS__, 'send_elementor_notice' ] );

            return false;
        }

        return true;
    }

    /**
     * Is MEC installed ?
     *
     * @since     1.0.0
     *
     * @return string|false
     */
    public static function is_mec_installed() {

        $file_path         = 'modern-events-calendar/mec.php';
        $installed_plugins = get_plugins();
        if ( isset( $installed_plugins[ $file_path ] ) ) {
            return 'pro';
        }
    }

    /**
     * Is elementor installed ?
     *
     * @since     1.0.0
     *
     * @return bool
     */
    public static function is_elementor_installed() {

        $file_path         = 'elementor/elementor.php';
        $installed_plugins = get_plugins();
        return isset( $installed_plugins[ $file_path ] );
    }

    /**
     * Send Admin Notice (MEC)
     *
     * @since 1.0.0
     *
     * @return void
     */
    public static function send_mec_notice( $type = false ) {

        $screen = get_current_screen();
        if ( isset( $screen->parent_file ) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id ) {

            return;
        }

        $plugin_pro = 'modern-events-calendar/mec.php';
        if ( self::is_mec_installed() == 'pro' ) {
            if ( ! current_user_can( 'activate_plugins' ) ) {

                return;
            }

            $activation_url = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin_pro . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin_pro );
            $message        = '<p>' . __( 'MEC FES Builder is not working because you need to activate the Modern Events Calendar plugin.', MECFBTEXTDOMAIN ) . '</p>';
            $message       .= '<p>' . sprintf( '<a href="%s" class="button-primary">%s</a>', $activation_url, __( 'Activate Modern Events Calendar Now', MECFBTEXTDOMAIN ) ) . '</p>';
        } else {
            if ( ! current_user_can( 'install_plugins' ) ) {

                return;
            }

            $install_url = 'https://webnus.net/modern-events-calendar/';
            $message     = '<p>' . __( 'MEC FES Builder is not working because you need to install the Modern Events Calendar plugin', MECFBTEXTDOMAIN ) . '</p>';
            $message    .= '<p>' . sprintf( '<a href="%s" target="_blank" class="button-primary">%s</a>', $install_url, __( 'Install Modern Events Calendar Now', MECFBTEXTDOMAIN ) ) . '</p>';
        }

        ?>
        <div class="notice notice-error is-dismissible">
            <p><?php echo $message; ?></p>
        </div>
        <?php
    }

    /**
     * Send Admin Notice ( Elementor )
     *
     * @since 1.0.0
     *
     * @return void
     */
    public static function send_elementor_notice() {

        $screen = get_current_screen();
        if ( isset( $screen->parent_file ) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id ) {

            return;
        }

        $plugin = 'elementor/elementor.php';
        if ( self::is_elementor_installed() ) {
            if ( ! current_user_can( 'activate_plugins' ) ) {

                return;
            }

            $activation_url = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin );
            $message        = '<p>' . __( 'Elementor FES Builder is not working because you need to activate the Elementor plugin.', MECFBTEXTDOMAIN ) . '</p>';
            $message       .= '<p>' . sprintf( '<a href="%s" class="button-primary">%s</a>', $activation_url, __( 'Activate Elementor Now', MECFBTEXTDOMAIN ) ) . '</p>';
        } else {
            if ( ! current_user_can( 'install_plugins' ) ) {

                return;
            }

            $install_url = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=elementor' ), 'install-plugin_elementor' );
            $message     = '<p>' . __( 'Elementor FES Builder is not working because you need to install the Elementor plugin', MECFBTEXTDOMAIN ) . '</p>';
            $message    .= '<p>' . sprintf( '<a href="%s" class="button-primary">%s</a>', $install_url, __( 'Install Elementor Now', MECFBTEXTDOMAIN ) ) . '</p>';
        }
        ?>
        <div class="notice notice-error is-dismissible">
            <p><?php echo $message; ?></p>
        </div>
        <?php
    }
}
