<?php
/**
 * Register widgets.
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder;

defined( 'ABSPATH' ) || exit;

use MEC\Singleton;
use Elementor\Plugin;
use MEC_FES_Builder\Widgets;

/**
 * Class Elementor.
 *
 * @since 1.0.0
 */
class Elementor extends Singleton {

	/**
	 * Init
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function init() {

		add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_enqueue_styles' ) );
		add_action( 'elementor/editor/after_enqueue_scripts', array( $this, 'editor_enqueue_scripts' ) );
		add_action( 'elementor/frontend/after_register_scripts', array( $this, 'register_scripts' ) );
		add_action( 'elementor/frontend/before_register_styles', array( $this, 'register_styles' ) );
		add_action( 'mec_fes_form_enqueue_scripts', array( $this, 'enqueue_style_and_scripts' ), 99 );
		add_action( 'elementor/widgets/register', array( $this, 'register_widgets' ) );
		add_action( 'elementor/elements/categories_registered', array( $this, 'widget_categories' ) );
	}

	/**
	 * Enqueue styles.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function editor_enqueue_styles() {

		wp_register_style( 'mec-fes-builder-editor', MEC_FES_BUILDER_PU_CSS . 'editor.css', array( 'mec-font-icons' ), MECFBVERSION );

		wp_enqueue_style( 'mec-fes-builder-editor' );
	}

	/**
	 * Enqueue scripts.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function editor_enqueue_scripts() {

		wp_register_script('mec-fes-builder-editor', MEC_FES_BUILDER_PU_JS. 'editor.js', array(), MECFBVERSION);

		wp_enqueue_script( 'mec-fes-builder-editor' );
	}

	/**
	 * Register widgets category.
	 *
	 * @param object $elements_manager
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function widget_categories( $elements_manager ) {

		$elements_manager->add_category(
			'FES_Builder',
			array(
				'title' => __( 'FES Builder', MECFBTEXTDOMAIN ),
			)
		);
	}

	/**
	 * Register widgets styles.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_styles() {

		wp_register_style( 'mec-fes-builder-frontend-style', MEC_FES_BUILDER_PU_CSS . 'styles.css', array( 'mec-frontend-style' ), MECFBVERSION );
	}

	/**
	 * Register widgets scripts.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_scripts() {

	}

	/**
	 * Enqueue styles and scripts.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function enqueue_style_and_scripts() {

		$this->register_styles();
		$this->register_scripts();

		wp_enqueue_style( 'mec-fes-builder-frontend-style' );
	}

	/**
	 * Register Elementor Widgets.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_widgets() {

		$is_edit_mode = Plugin::instance()->editor->is_edit_mode();
		// $is_preview_mode = Plugin::$instance->preview->is_preview_mode();

		if ( !$is_edit_mode || get_post_type() == 'mec-fes-builder' ) {

			Plugin::instance()->widgets_manager->register( new Widgets\Actions() );
			Plugin::instance()->widgets_manager->register( new Widgets\Title() );
			Plugin::instance()->widgets_manager->register( new Widgets\Description() );
			Plugin::instance()->widgets_manager->register( new Widgets\Excerpt() );
			Plugin::instance()->widgets_manager->register( new Widgets\CountdownMethod() );
			Plugin::instance()->widgets_manager->register( new Widgets\EventVisibility() );
			Plugin::instance()->widgets_manager->register( new Widgets\Categories() );
			Plugin::instance()->widgets_manager->register( new Widgets\Labels() );
			Plugin::instance()->widgets_manager->register( new Widgets\Tags() );
			Plugin::instance()->widgets_manager->register( new Widgets\Speakers() );
			Plugin::instance()->widgets_manager->register( new Widgets\Sponsors() );
			Plugin::instance()->widgets_manager->register( new Widgets\EventColor() );
			Plugin::instance()->widgets_manager->register( new Widgets\Cost() );
			Plugin::instance()->widgets_manager->register( new Widgets\Links() );
			Plugin::instance()->widgets_manager->register( new Widgets\FeaturedImage() );
			Plugin::instance()->widgets_manager->register( new Widgets\Note() );
			Plugin::instance()->widgets_manager->register( new Widgets\Recaptcha() );
			Plugin::instance()->widgets_manager->register( new Widgets\SubmitButton() );
			Plugin::instance()->widgets_manager->register( new Widgets\Agreement() );
			Plugin::instance()->widgets_manager->register( new Widgets\GuestFields() );
			Plugin::instance()->widgets_manager->register( new Widgets\Timezone() );
			Plugin::instance()->widgets_manager->register( new Widgets\EventData() );
			Plugin::instance()->widgets_manager->register( new Widgets\HourlySchedule() );
			Plugin::instance()->widgets_manager->register( new Widgets\Locations() );
			Plugin::instance()->widgets_manager->register( new Widgets\Organizers() );
			Plugin::instance()->widgets_manager->register( new Widgets\TotalBookingLimit() );
			Plugin::instance()->widgets_manager->register( new Widgets\MinimumTicketPerBooking() );
			Plugin::instance()->widgets_manager->register( new Widgets\DiscountPerUserRoles() );
			Plugin::instance()->widgets_manager->register( new Widgets\BookAllOccurrences() );
			Plugin::instance()->widgets_manager->register( new Widgets\IntervalOptions() );
			Plugin::instance()->widgets_manager->register( new Widgets\AutomaticApproval() );
			Plugin::instance()->widgets_manager->register( new Widgets\LastFewTicketsPercentage() );
			Plugin::instance()->widgets_manager->register( new Widgets\ThankyouPage() );
			Plugin::instance()->widgets_manager->register( new Widgets\BookingButtonLabel() );
			Plugin::instance()->widgets_manager->register( new Widgets\Gateways() );
			Plugin::instance()->widgets_manager->register( new Widgets\DateTime() );
			Plugin::instance()->widgets_manager->register( new Widgets\Fees() );
			Plugin::instance()->widgets_manager->register( new Widgets\BookingForm() );
			Plugin::instance()->widgets_manager->register( new Widgets\TicketVariations() );
			Plugin::instance()->widgets_manager->register( new Widgets\Attendees() );
			Plugin::instance()->widgets_manager->register( new Widgets\Tickets() );
			Plugin::instance()->widgets_manager->register( new Widgets\PublicDownload() );
			Plugin::instance()->widgets_manager->register( new Widgets\EventGallery() );
			Plugin::instance()->widgets_manager->register( new Widgets\DownloadableFile() );
			Plugin::instance()->widgets_manager->register( new Widgets\Occurrences() );
			Plugin::instance()->widgets_manager->register( new Widgets\OrganizerPayment() );
			Plugin::instance()->widgets_manager->register( new Widgets\Group() );


			if( class_exists( \MEC_Virtual_Events\Base::class ) ){

				Plugin::instance()->widgets_manager->register( new Widgets\VirtualEvent() );
			}

			if( class_exists( \MEC_Zoom_Integration\Base::class ) ){

				Plugin::instance()->widgets_manager->register( new Widgets\Zoom() );
			}

			if( class_exists( \MEC_RSVP\Base::class ) ){

				Plugin::instance()->widgets_manager->register( new Widgets\RSVP() );
			}

			if( class_exists( \MEC_Seat\Base::class ) ){

				Plugin::instance()->widgets_manager->register( new Widgets\Seat() );
			}

		}

	}
}
