<?php
/**
 * Widget Agreement.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * Agreement class
 *
 * @version 1.0.0
 */
class Agreement extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-fes-agreement';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-agreement';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Agreement', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-checkbox';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__('General', MECFBTEXTDOMAIN),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            )
		);

        $pages = array();
        $_pages = get_pages();
        foreach( $_pages as $page ){

            $pages[ $page->ID ] = $page->post_title;
        }

		$this->add_control(
			'agreement_page',
			array(
                'label' => __( 'Agreement page', MECFBTEXTDOMAIN ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => $pages,
            )
		);

        $this->switcher(array(
			'name' => 'checked',
			'label' => __( 'Checked', MECFBTEXTDOMAIN ),
			'type' => 'switcher',
		));

		$this->end_controls_section();

        $this->register_box_styles();
        $this->register_checkbox_styles();
        $this->register_label_styles();
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $atts = array(
            'checked' => 'yes' === $settings['checked'] ? true : false,
            'agreement_page' => $settings['agreement_page'],
            'is_edit_mode' => $this->is_edit_mode(),
        );

        $this->wrap_start();

        FormBuilder::agreement( $post, $atts );

        $this->wrap_end();
    }
}
