<?php
/**
 * Widget Attendees.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * Attendees class
 *
 * @version 1.0.0
 */
class Attendees extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec_meta_box_booking_options_form_attendees';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-attendees';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Attendees', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'eicon-lock-user';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {

        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_select_styles();

        $this->register_box_styles(
            'attendees_box_',
            "{$base_selector} .mec-attendees-wrapper .mec-attendees-list",
            "{$base_selector} .mec-attendees-wrapper .mec-attendees-list:hover",
            __( 'Attendees box', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'attendees_header_box_',
            "{$base_selector} .mec-attendees-wrapper .mec-attendees-list .w-clearfix:first-child",
            "{$base_selector} .mec-attendees-wrapper .mec-attendees-list .w-clearfix:first-child:hover",
            __( 'Attendees header box', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'attendees_header_item_',
            "{$base_selector} .mec-attendees-wrapper .mec-attendees-list .w-clearfix:first-child div",
            "{$base_selector} .mec-attendees-wrapper .mec-attendees-list .w-clearfix:first-child div:hover",
            __( 'Attendees header item', MECFBTEXTDOMAIN )
        );

        $this->register_general_styles(
            'attendees_content_',
            "{$base_selector} .mec-attendees-wrapper .mec-attendees-list .w-clearfix:nth-child(n+1) div",
            "{$base_selector} .mec-attendees-list div:nth-child(n+1) div:hover",
            __( 'Attendees content', MECFBTEXTDOMAIN )
        );

        $this->register_paragraph_styles(
            'not_found_',
            "{$base_selector} .mec-attendees-list .mec-not-found",
            "{$base_selector} .mec-attendees-list .mec-not-found:hover",
            __( 'Text Not Found', MECFBTEXTDOMAIN )
        );

        //TODO: add more options
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::attendees( $post, $atts );

        $this->wrap_end();
    }
}
