<?php
/**
 * Widget BookAllOccurrences.
 *
 * @since 1.0.0
 *
 * @package MEC_FES_Builder
 */

namespace MEC_FES_Builder\Widgets;

defined( 'ABSPATH' ) || exit;

use MEC\FES\FormBuilder;

/**
 * BookAllOccurrences class
 *
 * @version 1.0.0
 */
class BookAllOccurrences extends FESBuilderBase {

    /**
     * Wrap css selector
     *
     * @since 1.0.0
     *
     * @var string
     */
    public $fes_base_selector = '{{WRAPPER}} #mec-book-all-occurrences';

    /**
     * Return widget name
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_name(){

        return 'mec-fes-book-all-occurrences';
    }

    /**
     * Return widget title
     *
     * @since 1.0.0
     *
     * @return string
     */
    public function get_title(){

        return __( 'Book All Occurrences', MECFBTEXTDOMAIN );
    }

    /**
     * Return icon class css
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function get_icon() {

        return 'mec-fa-calendar';
    }

    /**
     * Return categories
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_categories() {

        return array( 'FES_Builder' );
    }

    /**
     * Return scripts
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_script_depends() {

        return array();
    }

    /**
     * Return styles
     *
     * @since 1.0.0
     *
     * @return array
     */
	public function get_style_depends() {

        return array();
    }

    /**
     * Register controls
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function register_controls() {
        $base_selector = $this->fes_base_selector;

        $this->register_box_styles();
        $this->register_header_styles();
        $this->register_checkbox_styles();
        $this->register_label_styles();

        $this->register_general_styles(
            'tooltip_box_',
            "{$base_selector} .mec-tooltip .box",
            "{$base_selector} ..mec-tooltip .box:hover",
            __( 'Tooltip Box', MECFBTEXTDOMAIN )
        );
        $this->register_general_styles(
            'tooltip_title_',
            "{$base_selector} .mec-tooltip .box h5",
            "{$base_selector} ..mec-tooltip .box h5:hover",
            __( 'Tooltip Title', MECFBTEXTDOMAIN )
        );
        $this->register_general_styles(
            'tooltip_content_',
            "{$base_selector} .mec-tooltip .box p",
            "{$base_selector} ..mec-tooltip .box p:hover",
            __( 'Tooltip Content', MECFBTEXTDOMAIN )
        );
    }

    /**
     * Render widget output
     *
     * @since 1.0.0
     *
     * @return void
     */
	protected function render() {

        $settings = $this->get_settings_for_display();

        $post = $this->get_post();

        $this->wrap_start();

        $atts = array(
            'is_edit_mode' => $this->is_edit_mode(),
        );

        FormBuilder::book_all_occurrences( $post, $atts );

        $this->wrap_end();
    }
}
